'::hui::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                                                                                      
//     

/**
 * @name HUI是一个富客户端应用的前端MVC框架
 * @public
 * @author haiyang5210
 * @date 2015-06-25 10:48
 */

// 使用window.hui定义可能会导致速度下降约7倍
window.hui = window.hui ? window.hui : {};

/**
 * @name Localstorage缓存方案
 */
// hui.loadjs = function (url) {
//     var s = document.createElement('script');
//     s.src = url;
//     document.documentElement.appendChild(s);
// };
// hui.savejs = function (str) {
//     var item = str.match(/^%22::[^:]*::%22;/)[0].replace(/(%22::|::%22;)/g, '').split('==');
//     var mod = item[0];
//     var ver = item[1];
//     var dist_str = window.decodeURI(str); // .replace(/%0A/g, '\n').replace(/%22/g, '"').replace(/%25/g, '%');
//     window.localStorage && window.localStorage.setItem(mod, dist_str);

//     var vlist_dist = window.localStorage ? (window.localStorage.getItem('vlist_dist') || '') : '';
//     vlist_dist = vlist_dist.replace(',' + mod + ':', ',:').replace(/,::[^,]*/, '');
//     vlist_dist = vlist_dist + ',' + mod + ':' + ver;
//     window.localStorage && window.localStorage.setItem('vlist_dist', vlist_dist);

//     eval(dist_str);
// };

hui.checkPackageUpdate = function (vnum_dist) {
    var mod;
    var version;
    var local;
    var item;
    var list = hui.versionlist;
    for (var i in list) {
        item = list[i];
        mod = item.split(':')[0];
        version = item.split(':')[1];
        local = window.localStorage ? String(window.localStorage.getItem(mod) || '') : '';
        if (local.indexOf('::' + item.replace(':', '==') + '::') !== 1) {
            hui.needreloadalljs = true;
        }
    }
    // 不需要重新加载
    if (!hui.needreloadalljs) {
        for (var i in list) {
            item = list[i];
            mod = item.split(':')[0];
            eval(window.localStorage.getItem(mod));
        }
    }
    // 有更新，需要重新加载
    else {
        hui.loadjs(hui.allsrc);
        hui.needreloadalljs = false;
    }

    // 缓存最新版本列表
    window.localStorage && window.localStorage.setItem('vlist_dist', (list.length ? ',' : '') + list.join(','));
    window.localStorage && window.localStorage.setItem('vnum_dist', '___' + vnum_dist + '___');
};
hui.loadFromLocalStorage = function () {
    var list = (window.localStorage ? window.localStorage.getItem('vlist_dist') || '' : '').split(',');
    for (var i in list) {
        if (list[i]) {
            var mod = list[i].split(':')[0];
            mod !== 'hui' && eval(window.localStorage.getItem(mod));
        }
    }
};
hui.updateByVersionList = function () {
    hui.loadjs('build/versionlist.js');
};

// hui.allsrc = 'build/all.js';
// hui.vnum_dist = '___4e0a6ef4b64590a468515cd0f698a19c___';
// hui.alldebug = 'build/all.debug.js';

// if (window.location.href.indexOf('debug') !== -1) {
//     hui.loadjs(hui.alldebug);
// }
// // 版本有更新，加载最新版本列表
// else if (!window.localStorage || window.localStorage.getItem('vnum_dist') !== hui.vnum_dist) {
//     window.localStorage.setItem('vnum_dist', hui.vnum_dist);
//     hui.loadjs(hui.allsrc);
// }
// // 版本无更新，直接从Localstorage里读取
// else {
//     hui.loadFromLocalStorage();
// }



if (!hui.define) {
    // Nodejs support 'require' and does not support 'define', browser does not supported both. 
    // hui.require(['jquery', 'button'], function(){})
    hui.require = function (n, cb, asyc) {
        if (!n) return;
        if (Object.prototype.toString.call(n) !== '[object Array]') {
            n = [n];
        }
        hui.define('', n, cb, asyc);
    };
    //define('lib_module',['lib@0.0.1','json@0.0.1'], function(exports){exports.todo='...';});
    hui.define = function (name, deps, fun, force, asyc) {
        if (force) hui.define.removeModule(name);
        if (!name || !hui.define.getModule(name)) {
            //Name missing. Allow for anonymous modules
            name = typeof name !== 'string' ? '' : String(name).toLowerCase();
            deps = deps && deps.splice && deps.length ? deps : [];
            var left = [];
            for (var i = 0, len = deps.length; i < len; i++) {
                left.push(String(deps[i]).toLowerCase());
            }

            var conf = {
                name: name,
                depend: deps,
                left: left,
                todo: fun,
                loaded: false,
                exports: {},
                asyc: asyc
            };
            hui.define.modules.push(conf);

            hui.define.checkDepend();

            if (asyc === 'syc' || hui.define.autoload !== false) {
                conf.left.length && hui.define.loadmod(conf.left);
            }
        }
    };
    // 注：模块源地址
    hui.define.source = 'http://bpmjs.org/api/combo??';
    // 注：已通过<script>标签发送请求的模块
    hui.define.loadfile = [];
    // 注：请求成功返回但尚未初始化的模块
    hui.define.modules = [];
    // 注：执行初始化后的模块
    hui.define.parsed = [];
    // 注：是否自动加载依赖模块
    hui.define.autoload = false;

    hui.define.loadmod = function (n, conf) {
        var left = [];
        for (var i = 0; i < n.length; i++) {
            if (!hui.define.checkLoaded(n[i], conf)) {
                left.push(n[i]);
            }
        }
        if (left.length) {
            hui.define.loadfile = hui.define.loadfile.concat(left);

            var url = hui.define.source + left.join(',');

            var ex = [];
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                hui.define.modules[i].name && ex.push(hui.define.modules[i].name);
            }
            var param = ex.length ? '?n=' + ex.join(',') : '';
            param = (param || '') + (hui.require.debug ? (param ? '&debug=true' : '?debug=true') : '');

            var script = document.createElement('script');
            script.src = url + (url.indexOf('.') === 0 ? '' : param);
            document.getElementsByTagName('head')[0].appendChild(script);
        }
    };
    hui.define.checkLoaded = function (n, conf) {
        var loaded = !!hui.define.getModule(n, conf);
        if (!loaded) {
            for (var i = 0, len = hui.define.loadfile.length; i < len; i++) {
                if (hui.define.loadfile[i].split('@')[0].replace('./', '') === n) {
                    loaded = true;
                    break;
                }
            }
        }
        return loaded;
    };

    hui.define.checkDepend = function () {
        hui.define.modules = hui.define.modules || [];
        // 注: 只能用倒序, 否则会碰到依赖项未定义的错误
        for (var i = hui.define.modules.length - 1; i > -1; i--) {
            var m = hui.define.modules[i];

            for (var j = 0, len2 = hui.define.parsed.length; j < len2; j++) {
                var n = hui.define.parsed[j];
                for (var k = m.left.length - 1; k > -1; k--) {
                    if (m.left[k].replace('./', '').split('@')[0] == n) {
                        m.left.splice(k, 1);
                    }
                }
            }

            if (!m.loaded && m.left.length < 1) {
                m.loaded = true;
                // 放在前面未执行todo就放到loaded中了，会误触其他函数的todo，只能放在后面
                // [注: push放在这里则后面检测依赖只能用倒序，放在后面不好实现][有误]
                m.todo && m.todo(m.exports);
                // 放在todo前面有问题，依赖项刚加载还没来得及执行就触发了其他依赖此项的todo，会报依赖项未定义的错误
                m.name && hui.define.parsed.push(m.name);

                i = hui.define.modules.length;
            }
        }
    };

    hui.define.getModule = function (n) {
        n = n.split('@')[0].replace('./', '');
        var module = null;
        if (hui.define.modules) {
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                if (hui.define.modules[i] && hui.define.modules[i].name === n) {
                    module = hui.define.modules[i];
                    break;
                }
            }
        }
        return module;
    };
    hui.define.removeModule = function (n) {
        n = n.split('@')[0].replace('./', '');
        var result = false;
        if (hui.define.modules) {
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                if (hui.define.modules[i] && hui.define.modules[i].name === n) {
                    hui.define.modules.splice(i, 1);
                    result = true;
                    break;
                }
            }
        }
        return result;
    };

    hui.define.checkLeft = function () {
        var left = [];
        var list = hui.define.modules;
        for (var i = 0, len = list.length; i < len; i++) {
            left = left.concat(hui.define.modules[i].left);
        }
        return left;
    };
    hui.define.loadLeft = function () {
        var left = hui.define.checkLeft();
        left && hui.define.loadmod(left);
    };
}

hui.define('hui', [], function () {
    // !!! global.hui = ...
    hui.window = window; /*hui.bocument = document;//注：hui.bocument与document不相同!!*/
    hui.window.cc = [];

    /** 
     * @name 为对象绑定方法和作用域
     * @param {Function|String} handler 要绑定的函数，或者一个在作用域下可用的函数名
     * @param {Object} obj 执行运行时this，如果不传入则运行时this为函数本身
     * @param {args* 0..n} args 函数执行时附加到执行时函数前面的参数
     * @returns {Function} 封装后的函数
     */
    hui.fn = function (func, scope) {
        if (Object.prototype.toString.call(func) === '[object String]') {
            func = scope[func];
        }
        if (Object.prototype.toString.call(func) !== '[object Function]') {
            throw 'Error "hui.util.fn()": "func" is null';
        }
        var xargs = arguments.length > 2 ? [].slice.call(arguments, 2) : null;
        return function () {
            var fn = '[object String]' == Object.prototype.toString.call(func) ? scope[func] : func,
                args = (xargs) ? xargs.concat([].slice.call(arguments, 0)) : arguments;
            return fn.apply(scope || fn, args);
        };
    };

    /**
 * @name 原型继承
 * @public
 * @param {Class} child 子类
 * @param {Class} parent 父类
 * @example 
    hui.ChildControl = function (options, pending) {
        //如果使用this.constructor.superClass.call将无法继续继承此子类,否则会造成死循环!!
        hui.ChildControl.superClass.call(this, options, 'pending');
        //进入控件处理主流程!
        if (pending != 'pending') {
            this.enterControl();
        }
    };
    hui.Form.prototype = {
        render: function () {
            hui.Form.superClass.prototype.render.call(this);
            //Todo...
        }
    };
    hui.inherits(hui.Form, hui.Control);
 */
    hui.inherits = function (child, parent) {
        var clazz = new Function();
        clazz.prototype = parent.prototype;

        var childProperty = child.prototype;
        child.prototype = new clazz();

        for (var key in childProperty) {
            if (childProperty.hasOwnProperty(key)) {
                child.prototype[key] = childProperty[key];
            }
        }

        child.prototype.constructor = child;

        //child是一个function
        //使用super在IE下会报错!!!
        child.superClass = parent;
    };



});

// 执行后续加载
hui.loadNext && hui.loadNext();
'::md5::';
'use strict';
/*
 * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 * Digest Algorithm, as defined in RFC 1321.
 * Version 2.1 Copyright (C) Paul Johnston 1999 - 2002.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for more info.
 */


var MD5 = (function () {
    /*
     * Perform a simple self-test to see if the VM is working
     */
    //function md5_vm_test()
    //{
    //  return hex_md5("abc") == "900150983cd24fb0d6963f7d28e17f72";
    //}
    /*
     * Configurable variables. You may need to tweak these to be compatible with
     * the server-side, but the defaults work in most cases.
     */
    var hexcase = 0; /* hex output format. 0 - lowercase; 1 - uppercase        */
    var b64pad = ""; /* base-64 pad character. "=" for strict RFC compliance   */
    var chrsz = 8; /* bits per input character. 8 - ASCII; 16 - Unicode      */

    /*
     * These are the functions you'll usually want to call
     * They take string arguments and return either hex or base-64 encoded strings
     */
    function hex_md5(s) {
        return binl2hex(core_md5(str2binl(s), s.length * chrsz));
    }
    /*
     * Calculate the MD5 of an array of little-endian words, and a bit length
     */
    function core_md5(x, len) {
        /* append padding */
        x[len >> 5] |= 0x80 << ((len) % 32);
        x[(((len + 64) >>> 9) << 4) + 14] = len;

        var a = 1732584193;
        var b = -271733879;
        var c = -1732584194;
        var d = 271733878;

        for (var i = 0; i < x.length; i += 16) {
            var olda = a;
            var oldb = b;
            var oldc = c;
            var oldd = d;

            a = md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
            d = md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
            c = md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
            b = md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
            a = md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
            d = md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
            c = md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
            b = md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
            a = md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
            d = md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
            c = md5_ff(c, d, a, b, x[i + 10], 17, -42063);
            b = md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
            a = md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
            d = md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
            c = md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
            b = md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);

            a = md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
            d = md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
            c = md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
            b = md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
            a = md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
            d = md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
            c = md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
            b = md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
            a = md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
            d = md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
            c = md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
            b = md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
            a = md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
            d = md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
            c = md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
            b = md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);

            a = md5_hh(a, b, c, d, x[i + 5], 4, -378558);
            d = md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
            c = md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
            b = md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
            a = md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
            d = md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
            c = md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
            b = md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
            a = md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
            d = md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
            c = md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
            b = md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
            a = md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
            d = md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
            c = md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
            b = md5_hh(b, c, d, a, x[i + 2], 23, -995338651);

            a = md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
            d = md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
            c = md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
            b = md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
            a = md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
            d = md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
            c = md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
            b = md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
            a = md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
            d = md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
            c = md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
            b = md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
            a = md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
            d = md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
            c = md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
            b = md5_ii(b, c, d, a, x[i + 9], 21, -343485551);

            a = safe_add(a, olda);
            b = safe_add(b, oldb);
            c = safe_add(c, oldc);
            d = safe_add(d, oldd);
        }
        return Array(a, b, c, d);

    }

    /*
     * These functions implement the four basic operations the algorithm uses.
     */
    function md5_cmn(q, a, b, x, s, t) {
        return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b);
    }

    function md5_ff(a, b, c, d, x, s, t) {
        return md5_cmn((b & c) | ((~b) & d), a, b, x, s, t);
    }

    function md5_gg(a, b, c, d, x, s, t) {
        return md5_cmn((b & d) | (c & (~d)), a, b, x, s, t);
    }

    function md5_hh(a, b, c, d, x, s, t) {
        return md5_cmn(b ^ c ^ d, a, b, x, s, t);
    }

    function md5_ii(a, b, c, d, x, s, t) {
        return md5_cmn(c ^ (b | (~d)), a, b, x, s, t);
    }



    /*
     * Add integers, wrapping at 2^32. This uses 16-bit operations internally
     * to work around bugs in some JS interpreters.
     */
    function safe_add(x, y) {
        var lsw = (x & 0xFFFF) + (y & 0xFFFF);
        var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xFFFF);
    }

    /*
     * Bitwise rotate a 32-bit number to the left.
     */
    function bit_rol(num, cnt) {
        return (num << cnt) | (num >>> (32 - cnt));
    }

    /*
     * Convert a string to an array of little-endian words
     * If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
     */
    //不能删
    function str2binl(str) {
        var bin = Array();
        var mask = (1 << chrsz) - 1;
        for (var i = 0; i < str.length * chrsz; i += chrsz)
            bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (i % 32);
        return bin;
    }



    /*
     * Convert an array of little-endian words to a hex string.
     */
    //不能删
    function binl2hex(binarray) {
        var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
        var str = "";
        for (var i = 0; i < binarray.length * 4; i++) {
            str += hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8 + 4)) & 0xF) +
                hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8)) & 0xF);
        }
        return str;
    }

    return {
        'encode': hex_md5
    };
})();

window.MD5 = MD5;
'::hui_action::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   

/**
 * @name @name 页面流程控制类
 * @public
 * @author wanghaiyang
 * @date 2014/05/05
 * @param {Object} options 控件初始化参数.
 */
hui.define('hui_action', ['hui_template', 'hui_control'], function () {

    hui.BaseModel = function (data) {
        hui.EventDispatcher.call(this);

        var _model = {};
        /**
         * @name 设置新的值，如果两个值不同，就会触发PropertyChangedEvent.
         * @param {String|Object} propertyName 需要设置的属性或数据对象.
         * @param {Any} value 属性的值.
         * @comment 接受`"key", value` 和 `{key: value}`两种的方式赋值.
         */
        this.set = function (propertyName, newValue) {
            var attr,
                attrs,
                changes = [],
                newValue,
                className = Object.prototype.toString.call(propertyName);

            if ((className !== '[object Object]' && className !== '[object String]') ||
                (className === '[object Object]' && newValue !== undefined)) {
                return this.trigger('SET_ERROR', propertyName, newValue);
            }

            if (className == '[object String]') {
                attrs = {};
                attrs[propertyName] = newValue;
            }
            else {
                attrs = propertyName;
            }

            for (attr in attrs) {
                if (!Object.prototype.hasOwnProperty.call(_model, attr)) {
                    changes.push([attr, undefined, hui.BaseModel.clone(attrs[attr])]);
                    _model[attr] = newValue;
                }
                else if (!hui.BaseModel.isEqual(_model[attr], attrs[attr])) {
                    changes.push([attr, hui.BaseModel.clone(_model[attr]), hui.BaseModel.clone(attrs[attr])]);
                    _model[attr] = attrs[attr];
                }
                // IE6,7 can not use JSON.stringify(), just use simple compare.
                else if (_model[attr] !== attrs[attr]) {
                    changes.push([attr, hui.BaseModel.clone(_model[attr]), hui.BaseModel.clone(attrs[attr])]);
                    _model[attr] = attrs[attr];
                }
            }

            // Trigger all relevant attribute changes.
            for (var i = 0, len = changes.length; i < len; i++) {
                this.trigger('change:' + changes[i][0], changes[i][1], changes[i][2]);
            }
            if (changes.length) {
                this.trigger('change');
            }
        };

        /**
         * @name 获取指定属性值
         * @param {String} propertyName 属性名.
         * @return {*} 属性的值.
         */
        this.get = function (propertyName) {
            return hui.BaseModel.clone(_model[propertyName]);
        };
        /**
         * @name 获取所有的属性值
         * @return {Map} 所有的属性值.
         */
        this.getData = function () {
            return hui.BaseModel.clone(_model);
        };
        /**
         * @name 移除指定属性值
         * @param {String} propertyName 属性名.
         * @return {*} 属性的值.
         */
        this.remove = function (propertyName) {
            var value = _model[propertyName];
            this.set(propertyName, undefined);
            delete _model[propertyName];
            return value;
        };
        /**
         * @name 销毁Model
         * @return {void}
         */
        this.dispose = function () {
            this._listeners = undefined;
            _model = undefined;
        };

        var child = _model,
            parent = data;
        for (var key in parent) {
            if (parent.hasOwnProperty(key)) {
                child[key] = parent[key];
            }
        }
    };

    hui.BaseModel.isEqual = function (a, b, aStack, bStack) {
        // Identical objects are equal. `0 === -0`, but they aren't identical.
        // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.
        if (a === b) {
            return a !== 0 || 1 / a == 1 / b;
        }
        // A strict comparison is necessary because `null == undefined`.
        if (a === null || b === null || a === undefined || b === undefined) {
            return a === b;
        }
        if (aStack === undefined || bStack === undefined) {
            aStack = [];
            bStack = [];
        }
        // Compare `[[Class]]` names.
        var className = Object.prototype.toString.call(a);
        if (className != Object.prototype.toString.call(b)) {
            return false;
        }
        switch (className) {
            // Strings, numbers, dates, and booleans are compared by value.
        case '[object String]':
            // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
            // equivalent to `new String("5")`.
            return a == String(b);
        case '[object Number]':
            // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
            // other numeric values.
            return a != +a ? b != +b : (a === 0 ? 1 / a === 1 / b : a === +b);
        case '[object Date]':
        case '[object Boolean]':
            // Coerce dates and booleans to numeric primitive values. Dates are compared by their
            // millisecond representations. Note that invalid dates with millisecond representations
            // of `NaN` are not equivalent.
            return +a == +b;
            // RegExps are compared by their source patterns and flags.
        case '[object RegExp]':
            return a.source == b.source &&
                a.global == b.global &&
                a.multiline == b.multiline &&
                a.ignoreCase == b.ignoreCase;
        }
        if (typeof a != 'object' || typeof b != 'object') return false;
        // Assume equality for cyclic structures. The algorithm for detecting cyclic
        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
        var length = aStack.length;
        while (length--) {
            // Linear search. Performance is inversely proportional to the number of
            // unique nested structures.
            if (aStack[length] == a) return bStack[length] == b;
        }
        // Add the first object to the stack of traversed objects.
        aStack.push(a);
        bStack.push(b);

        var size = 0,
            result = true;
        // Recursively compare objects and arrays.
        if (className == '[object Array]') {
            // Compare array lengths to determine if a deep comparison is necessary.
            size = a.length;
            result = size == b.length;
            if (result) {
                // Deep compare the contents, ignoring non-numeric properties.
                while (size--) {
                    if (!(result = hui.BaseModel.isEqual(a[size], b[size], aStack, bStack))) break;
                }
            }
        }
        else {
            // Objects with different constructors are not equivalent, but `Object`s
            // from different frames are.
            var aCtor = a.constructor,
                bCtor = b.constructor;
            if (aCtor !== bCtor && !(Object.prototype.toString.call(aCtor) == '[object Function]' && (aCtor instanceof aCtor) &&
                Object.prototype.toString.call(bCtor) == '[object Function]' && (bCtor instanceof bCtor))) {
                return false;
            }
            // Deep compare objects.
            for (var key in a) {
                if (Object.prototype.hasOwnProperty.call(a, key)) {
                    // Count the expected number of properties.
                    size++;
                    // Deep compare each member.
                    if (!(result = Object.prototype.hasOwnProperty.call(b, key) && hui.BaseModel.isEqual(a[key], b[key], aStack, bStack))) break;
                }
            }
            // Ensure that both objects contain the same number of properties.
            if (result) {
                for (key in b) {
                    if (Object.prototype.hasOwnProperty.call(b, key) && !(size--)) break;
                }
                result = !size;
            }
        }
        // Remove the first object from the stack of traversed objects.
        aStack.pop();
        bStack.pop();

        return result;
    };
    hui.inherits(hui.BaseModel, hui.EventDispatcher);

    /** 
     * @name对一个object进行深度拷贝
     * @param {Any} source 需要进行拷贝的对象.
     * @param {Array} oldArr 源对象树索引.
     * @param {Array} newArr 目标对象树索引.
     * @return {Any} 拷贝后的新对象.
     */
    hui.BaseModel.clone = function (source, oldArr, newArr) {
        if (typeof source === 'undefined') {
            return undefined;
        }
        if (typeof JSON !== 'undefined') {
            return JSON.parse(JSON.stringify(source));
        }

        var result = source,
            i,
            len,
            j,
            len2,
            exist = -1;
        oldArr = oldArr || [];
        newArr = newArr || [];

        if (source instanceof Date) {
            result = new Date(source.getTime());
        }
        else if ((source instanceof Array) || (Object.prototype.toString.call(source) == '[object Object]')) {
            for (j = 0, len2 = oldArr.length; j < len2; j++) {
                if (oldArr[j] == source) {
                    exist = j;
                    break;
                }
            }
            if (exist != -1) {
                result = newArr[exist];
                exist = -1;
            }
            else {
                if (source instanceof Array) {
                    result = [];
                    oldArr.push(source);
                    newArr.push(result);
                    var resultLen = 0;
                    for (i = 0, len = source.length; i < len; i++) {
                        result[resultLen++] = hui.BaseModel.clone(source[i], oldArr, newArr);
                    }
                }
                else if (!!source && Object.prototype.toString.call(source) == '[object Object]') {
                    result = {};
                    oldArr.push(source);
                    newArr.push(result);
                    for (i in source) {
                        if (source.hasOwnProperty(i)) {
                            result[i] = hui.BaseModel.clone(source[i], oldArr, newArr);
                        }
                    }
                }
            }
        }

        return result;
    };

    hui.Action = function (options) {
        // 防止重复执行!!
        if (this.baseConstructed) {
            return this;
        }
        hui.Action.superClass.call(this, options, 'pending');
        /**
         * @name Action的页面主元素ID[容器]
         * @public
         * @return {Map}
         */
        this.main = null;
        // Action的模板名
        this.view = null;
        // Action的数据模型
        var baseModel = hui.Action.getExtClass('hui.BaseModel');
        this.model = new baseModel();
        // Action的顶层控件容器
        this.cc = [];
        // 声明类型
        this.type = 'action';

        // 是否执行过构造过程
        this.baseConstructed = true;

        hui.Control.appendControl(hui.window, this);

        // enterControl需要在实例化时调用，这里不能直接进!
        // this.enterControl()
    };

    hui.Action.prototype = {
        /**
         * @name Action的主要处理流程
         * @protected
         * @param {Object} argMap arg表.
         */
        enterControl: function (args) {
            var me = this;
            //Action渲染过程中禁止跳转，否则容易造成死循环。
            hui.Action.getExtClass('hui.Master').ready = false;
            // 设为活动action 
            me.active = true;

            // 保存通过URL传过来的参数
            me.querystring = args;
            // 判断model是否存在，不存在则新建一个
            if (!me.model) {
                var baseModel = hui.Action.getExtClass('hui.BaseModel');
                me.model = new baseModel();
            }

            hui.Action.getExtClass('hui.Control').prototype.enterControl.call(me, function () {
                // hui.Action.getExtClass('hui.Mask').hideLoading();
                // 渲染结束，检查渲染期间是否有新请求
                hui.Action.getExtClass('hui.Master').checkNewRequest();
            });
        },
        render: function () {
            var me = this,
                main = me.getMain(),
                data = me.model && me.model.getData && typeof me.model.getData === 'function' ? me.model.getData() : {};
            hui.Control.init(main, data, me);
            // 设置_rendered
            main.setAttribute('_rendered', 'true');
        },
        /**
         * @name 初始化数据模型
         * @protected
         * @param {Object} argMap 初始化的参数.
         */
        // initModel: function (callback) {
        //     callback && callback();
        // },
        // checkAuthority: function(){},
        /**
         * @name 提交完成的事件处理函数,提示完成
         * @private
         * @param {Object} data 提交的返回数据.
         */
        onsubmitfinished: function (data) {
            // Todo: 
        },
        /**
         * @name 释放控件
         * @protected
         */
        dispose: function () {
            var me = this;

            me.leave && me.leave();

            hui.Control.prototype.dispose.call(me);

            if (me.model && me.model.dispose) {
                me.model.dispose();
                me.model = undefined;
            }

            me.active = null;

            me.clear && me.clear();
        },
        /**
         * @name 后退
         * @protected
         */
        back: function () {
            hui.Action.getExtClass('hui.Master').back();
        },
        /**
         * @name 退出
         * @public
         */
        leave: function () {},
        moveIn: function () {
            var me = this,
                main = me.getMain ? me.getMain() : null;
            if (main) {
                main.style.display = 'block';
            }
        },
        moveOut: function () {
            var me = this,
                main = me.getMain ? me.getMain() : null;
            if (main) {
                main.style.display = 'none';
            }
        }
    };

    hui.inherits(hui.Action, hui.Control);

    /**
     * @name 通过Action类派生出action
     * @public
     * @param {Object} action 对象
     * @public
     */
    hui.Action.derive = function (action) {
        var me,
            i,
            instance,
            func = function () {},
            type = Object.prototype.toString.call(action);
        // 传进来的是一个Function
        if (type == '[object Function]') {
            hui.inherits(action, hui.Action);
            hui.inherits(func, action);

            // 相当于在传入的构造函数最前面执行hui.Action.call(this);
            instance = new func();
            hui.Action.call(instance);
            action.call(instance);
            /**/
        }
        // 传进来的是一个单例object
        else if (type == '[object Object]' || type == '[object String]') {
            action = type == '[object String]' ? hui.window[action] : action;

            me = new hui.Action();
            for (i in me) {
                if (action[i] === undefined) {
                    action[i] = me[i];
                }
            }
            var exist = false;
            for (var i = 0, len = hui.window.cc.length; i < len; i++) {
                if (hui.window.cc[i] === action) {
                    exist = true;
                    break;
                }
            }
            if (!exist) {
                hui.window.cc.push(action);
            }
        }
    };
    hui.Action.MAIN_ID = 'main';

    /** 
     * @name 根据字符串查找对象
     * @param {String} name 对象对应的字符串
     * @param {Object} opt_obj 父对象
     * @public
     */
    hui.Action.getObjectByName = function (name, opt_obj) {
        var parts = name.split('.'),
            part,
            cur = opt_obj || hui.window;
        while (cur && (part = parts.shift())) {
            cur = cur[part];
        }
        return cur;
    };

    hui.Action.getExtClass = function (clazz) {
        var result = function () {};
        switch (clazz) {
        case 'hui.Control':
            if (typeof hui !== 'undefined' && hui && hui.Control) {
                result = hui.Control;
            }
            else {
                result.get = new Function();
                result.init = new Function();
                result.prototype.validate = new Function();
                result.prototype.getParamMap = new Function();
                result.prototype.validateAndSubmit = new Function();
            }
            break;
        case 'hui.Template':
            if (typeof hui !== 'undefined' && hui && hui.Template) {
                result = hui.Template;
            }
            else {
                result.getTarget = new Function();
                result.merge = new Function();
            }
            break;
        case 'hui.Flow':
            if (typeof hui !== 'undefined' && hui && hui.Flow) {
                result = hui.Flow;
            }
            else {
                result.push = new Function();
                result.next = new Function();
            }
            break;
        case 'hui.Mask':
            if (typeof hui !== 'undefined' && hui && hui.Mask) {
                result = hui.Mask;
            }
            else {
                result.hideLoading = new Function();
            }
            break;
        case 'hui.Master':
            if (typeof hui !== 'undefined' && hui && hui.Master) {
                result = hui.Master;
            }
            else {
                result.checkNewRequest = new Function();
                result.back = new Function();
            }
            break;
        case 'hui.BaseModel':
            if (typeof hui !== 'undefined' && hui && hui.BaseModel) {
                result = hui.BaseModel;
            }
            else {
                result.prototype.set = new Function();
            }
            break;
        default:
        }
        return result;
    };

    hui.Router = {
        pathRules: [],
        /**
         * @name 根据location找到匹配的rule并返回对应的action
         * @public
         * @param {String} loc 路径
         */
        findAction: function (loc) {
            var me = this,
                pathRules = me.pathRules,
                i, len, matches, rule,
                action = null;
            //匹配所有符合表达式的路径[正则表达式]
            for (i = 0, len = pathRules.length; i < len; i++) {
                rule = pathRules[i].location;
                if (rule && (rule instanceof RegExp) && (matches = rule.exec(loc)) !== null) {
                    action = pathRules[i].action;
                }
            }
            //[优先]匹配单独具体路径
            for (i = 0, len = pathRules.length; i < len; i++) {
                rule = pathRules[i].location;
                if (rule && (typeof rule == 'string') && rule == loc) {
                    action = pathRules[i].action;
                }
            }

            if (!action && hui.window.console && hui.window.console.error) {
                hui.window.console.error('Route \'%s\' is not defined. Please use hui.Router.setRule(\'%s\', \'xxx\');', loc, loc);
            }

            return action;
        },
        /**
         * @name 设置rule
         * @public
         * @param {String} rule 路径
         * @param {String} action 对应action
         */
        setRule: function (rule, action) {
            this.pathRules.push({
                'location': rule,
                'action': action
            });

            if (Object.prototype.toString.call(action) === '[object Object]') {
                var exist = false;
                for (var i = 0, len = hui.window.cc.length; i < len; i++) {
                    if (hui.window.cc[i] === action) {
                        exist = true;
                        break;
                    }
                }
                if (!exist) {
                    hui.window.cc.push(action);
                }
            }
        },
        /**
         * @name 载入完成读取所有rule
         * @protected
         * @param {String} rule 路径
         * @param {String} func 对应action
         */
        init: function (modules) {
            // Todo:
        },

        //错误处理
        error: function (msg) {
            msg = 'error: ' + msg;
            if (hui.window.console) {
                hui.window.console.log(msg);
            }
            else throw Error(msg);
        }
    };

    hui.Master = {
        historyList: [],
        newRequest: null,
        ready: true,
        checkNewRequest: function () {
            var me = this,
                url = me.newRequest;

            me.ready = true;

            if (url) {
                me.newRequest = null;
                me.forward(url);
            }
        },

        //仅供redirect时调用,必须保证url对应的action是有效的,跳转过程中不操作url,不推荐外部直接调用!!!
        forward: function (url) {
            var me = this;
            // 注：由于forward的过程中不改变url，因此将可能改变url的hui.Permission.checkRouter放到hui.Locator.switchToLocation中了
            // 这里不可以通过me.getExtClass()去取!!
            // if (hui.Permission && hui.Permission.checkRouter) {
            //     hui.Permission.checkRouter(url, hui.fn(me.forwardCallback, me));
            // }
            // else {
            me.forwardCallback(url);
            //}
        },
        // 权限验证可能是一个异步过程!!
        forwardCallback: function (url) {
            var me = this,
                result, loc, args,
                action = null,
                actionName = null;

            // Action渲染过程中禁止跳转，否则容易造成死循环，缓存新请求。
            if (me.ready === false) {
                me.newRequest = url;
            }
            if (me.ready === true) {
                result = me.parseLocator(url);
                loc = result['location'];
                args = result['query'];

                // 首先销毁当前action的实例
                if (me.historyList[me.historyList.length - 1]) {
                    // me.disposeAction(me.parseLocator(me.historyList[me.historyList.length - 1])['location']);
                    action = me.getActionInstance(me.findActionNameByLocation(me.parseLocator(me.historyList[me.historyList.length - 1])['location']));
                    if (action) {
                        if (loc === me.historyList[me.historyList.length - 1]) {
                            action.dispose && action.dispose();
                        }
                        else {
                            action.moveOut ? action.moveOut() : hui.Action.prototype.moveOut.call(action);
                        }
                    }

                }

                // 找到匹配的路径规则(该过程中会创建action实例)
                actionName = me.findActionNameByLocation(loc);
                action = me.getActionInstance(actionName) || me.createActionInstance(actionName); /* me.getActionInstance参数可以接收'变量名'|'单例'|'Action子类' */

                if (action && action.enterControl) {
                    //Action渲染过程中禁止跳转，否则容易造成死循环。
                    // 注：为解决手动构造action当url变化时不能刷新的问题，将me.ready = false; 移到了enterControl()中
                    //me.ready = false;
                    //时间不长则无需显示等待中
                    //hui.Mask.timer = hui.window.setTimeout('hui.Mask.showLoading()',300);
                    //me.getExtClass('hui.Mask').showLoading();

                    me.historyList.push(url);
                    action.enterControl(args);
                    action.moveIn && action.moveIn();
                }
                else if (action) {
                    me.historyList.push(url);
                    hui.Action.prototype.enterControl.call(action, args);
                    (action.moveIn ? action.moveIn() : hui.Action.prototype.moveIn.call(action));
                }
            }
        },
        back: function () {
            var me = this,
                result, loc;

            //有历史记录
            if (me.historyList.length > 1) {
                //当前action
                result = me.parseLocator(me.historyList.pop());
                loc = result.location;

                me.disposeAction(loc);

                me.ready = true;
                //后退一步
                me.getExtClass('hui.Locator').redirect(me.historyList.pop());
            }
            //无历史记录
            else {
                //当前action
                result = me.parseLocator(me.historyList[me.historyList.length - 1]);
                loc = result.location;

                //跳转到指定后退location
                loc = me.disposeAction(loc);
                if (loc) {
                    me.getExtClass('hui.Locator').redirect(loc);
                }
            }
        },
        /**
         * @name 根据loc找到action
         * @private
         * @param {String} loc
         * @param {String} log 是否显示错误提示，disposeAction()时无需显示错误提示
         * @result {Object|Function} actionName
         * @comment 
            1. hui.Router.setRule('/a', {enterControl:function(){}});
            2. hui.Router.setRule('/a', function(){});
            3. hui.Router.setRule('/a', 'window.Detail';
         */
        findActionNameByLocation: function (loc, nolog) {
            var me = this,
                action = me.getExtClass('hui.Router').findAction(loc),
                actionClazz = action && Object.prototype.toString.call(action) === '[object String]' ?
                hui[action] || hui.Action.getObjectByName(action) : null;

            if ('[object Object][object Function]'.indexOf(Object.prototype.toString.call(action)) === -1 && !actionClazz) {
                // 找不到对应Action
                if (nolog !== 'nolog' && hui.window.console && hui.window.console.error) {
                    hui.window.console.error('hui.Router.setRule(\'%s\', \'%s\'); Action \'%s\' is not exist.', loc, action, action);
                }
                // 找不到则返回404
                if (loc !== '/404') {
                    action = me.findActionNameByLocation('/404');
                }
            }
            return action;
        },
        /**
         * @name 根据loc找到action
         * @private
         * @param {String} loc
         */
        disposeAction: function (loc) {
            var me = this,
                action = me.getActionInstance(me.findActionNameByLocation(loc, 'nolog')),
                /* getByActionName参数可以接收'变量名'|'单例'|'Action子类' */
                defaultBack = (action && action.BACK_LOCATION) ? action.BACK_LOCATION : null;

            if (action && action.dispose) {
                action.dispose();
            }
            else if (action) {
                hui.Action.prototype.dispose.call(action);
            }

            return defaultBack;
        },
        /**
         * @name 返回对应action的实例
         * @private
         * @param {ObjectString|Function|} 有效的actionName，无效me.findActionNameByLocation会报错
         */
        getActionInstance: function (actionName) {
            var action = null;
            if (Object.prototype.toString.call(actionName) === '[object String]') {
                var list = hui.window.cc;
                for (var i = 0, len = list.length; i < len; i++) {
                    if (list[i] && list[i].id === actionName) {
                        action = list[i];
                    }
                }
                if (!action) {
                    actionName = hui[actionName] || hui.Action.getObjectByName(actionName);
                }
            }

            if (!action && Object.prototype.toString.call(actionName) === '[object Object]') {
                action = actionName;
            }
            /*
            // 注: 注释原因是 [找到匹配的路径规则(该过程中会创建action实例)]过程中的me.findActionNameByLocation(loc)已作处理
            if (!action && hui.window.console && hui.window.console.error) {
                hui.window.console.error('Action clazz \''+actionName+'\' not exist.');
            }*/
            if (!action && Object.prototype.toString.call(actionName) === '[object Function]') {
                var exist = false;
                for (var i = 0, len = hui.window.cc.length; i < len; i++) {
                    if (hui.window.cc[i] instanceof actionName) {
                        exist = true;
                        action = hui.window.cc[i];
                        break;
                    }
                }
            }

            return action;
        },
        createActionInstance: function (actionName) {
            var action = null;
            if (Object.prototype.toString.call(actionName) === '[object String]') {
                var list = hui.window.cc;
                for (var i = 0, len = list.length; i < len; i++) {
                    if (list[i] && list[i].id === actionName) {
                        action = list[i];
                    }
                }
                if (!action) {
                    actionName = hui[actionName] || hui.Action.getObjectByName(actionName);
                }
            }

            if (!action && Object.prototype.toString.call(actionName) === '[object Object]') {
                action = actionName;
            }
            /*
            // 注: 注释原因是 [找到匹配的路径规则(该过程中会创建action实例)]过程中的me.findActionNameByLocation(loc)已作处理
            if (!action && hui.window.console && hui.window.console.error) {
                hui.window.console.error('Action clazz \''+actionName+'\' not exist.');
            }*/
            if (!action && Object.prototype.toString.call(actionName) === '[object Function]') {
                var exist = false;
                for (var i = 0, len = hui.window.cc.length; i < len; i++) {
                    if (hui.window.cc[i] instanceof actionName) {
                        exist = true;
                        action = hui.window.cc[i];
                        break;
                    }
                }
                if (!exist) {
                    var action = new actionName();
                    // 注：上面new的过程可能会改变hui.window.childControl！因此需要重新检查！
                    for (var i = 0, len = hui.window.cc.length; i < len; i++) {
                        if (hui.window.cc[i] instanceof actionName) {
                            exist = true;
                            action = hui.window.cc[i];
                            break;
                        }
                    }
                    if (!exist) {
                        hui.window.cc.push(action);
                    }
                }
            }

            return action;
        },

        /**
         * @name 返回当前action实例
         * @public
         */
        get: function () {
            var me = this,
                loc = hui.Master.parseLocator();
            return me.getActionInstance(me.findActionNameByLocation(loc.location, 'nolog'));
        },
        /**
         * @name 解析获取到的location字符串
         * @private
         * @param {Object} loc
         */
        parseLocator: function (url) {
            url = url === null || url === undefined ? hui.window.location.href : String(url);
            var pair,
                query = {},
                loc = '',
                args = '',
                list,
                v,
                str = url.split('#'),
                href;

            if (~url.indexOf('?')) {
                // Parse ?aa=xxx
                pair = str[0].match(/^([^\?]*)(\?(.*))?$/);
                if (pair) {
                    //loc = pair[1];
                    args = (pair.length == 4 ? pair[3] : '') || '';
                }
                list = args ? args.split('&') : [];
                for (var i = 0, len = list.length; i < len; i++) {
                    v = list[i].split('=');
                    v.push('');
                    query[v[0]] = hui.Control.decode(v[1]);
                }
            }
            if (~url.indexOf('#') || str.length === 1) {
                href = str.length === 1 ? str[0] : str[1];
                href = href.replace(/^!/, '');
                // Parse #~bb=xxx
                pair = href.match(/^([^~]*)(~(.*))?$/);
                if (pair) {
                    loc = pair[1];
                    args = (pair.length == 4 ? pair[3] : '') || '';
                }
                list = args ? args.split('&') : [];
                for (var i = 0, len = list.length; i < len; i++) {
                    v = list[i].split('=');
                    v.push('');
                    query[v[0]] = hui.Control.decode(v[1]);
                }
            }

            return {
                'location': loc,
                'query': query
            };
        },
        /**
         * @name 初始化控制器,包括路由器和定位器locator
         * @protected
         * @param {String} rule 路径
         * @param {String} func 对应action
         */
        init: function () {
            //var me = this;
        },
        getExtClass: function (clazz) {
            var result = function () {};
            switch (clazz) {
                //me.getExtClass('hui.Mask')
            case 'hui.Mask':
                if (typeof hui !== 'undefined' && hui && hui.Mask) {
                    result = hui.Mask;
                }
                else {
                    result.showLoading = new Function();
                    result.hideLoading = new Function();
                }
                break;
                //me.getExtClass('hui.Locator')
            case 'hui.Locator':
                if (typeof hui !== 'undefined' && hui && hui.Locator) {
                    result = hui.Locator;
                }
                else {
                    result.redirect = new Function();
                }
                break;
                //me.getExtClass('hui.Action')
            case 'hui.Action':
                if (typeof hui !== 'undefined' && hui && hui.Action) {
                    result = hui.Action;
                }
                else {
                    result.getByActionName = new Function();
                }
                break;
                //me.getExtClass('hui.Router')
            case 'hui.Router':
                if (typeof hui !== 'undefined' && hui && hui.Router) {
                    result = hui.Router;
                }
                else {
                    result.findAction = new Function();
                }
                break;
            default:
            }
            return result;
        }
    };

    hui.Locator = {
        /**
         * @name 默认首次进入的路径.
         * @default '/'
         * @public
         */
        DEFAULT_INDEX: '/',
        /**
         * @name 当前路径.
         * @public
         */
        currentLocation: null,
        /**
         * @name 使用iframe兼容早期IE版本无法通过onhashchange保存浏览历史的问题.
         * @private
         */
        CONTROL_IFRAME_ID: 'ERHistroyRecordIframe' + String(Math.random()).replace('.', ''),
        IFRAME_CONTENT: [
            '<html><head></head><body><input type="text" id="save">',
            '<script type="text/javascript">',
            'var loc = "{{0}}";',
            'document.getElementById("save").value = loc;',
            'parent.hui.Locator.updateLocation(loc);',
            'parent.hui.Locator.switchToLocation(loc);<',
            '/script></body></html>'
        ].join(''),
        /**
         * @name 获取location信息
         * @private
         * @return {String}
         */
        getLocation: function () {
            var hash;

            // firefox下location.hash会自动decode
            // 体现在：
            //   * 视觉上相当于decodeURI，
            //   * 但是读取location.hash的值相当于decodeURIComponent
            // 所以需要从location.href里取出hash值
            if (/firefox\/(\d+\.\d+)/i.test(navigator.userAgent) ? +RegExp['\x241'] : undefined) {
                hash = location.href.match(/#(.*)$/);
                hash && (hash = hash[1]);
            }
            else {
                hash = location.hash;
            }

            if (hash) {
                return hash.replace(/^#!+/, '').replace(/^#/, '').replace(/^!+/, '');
            }

            return '';
        },
        /**
         * @name 更新hash信息
         * @private
         * @param {String} loc
         */
        updateLocation: function (loc) {
            var me = this,
                isChange = (me.currentLocation != loc);

            // 存储当前信息
            // opera下，相同的hash重复写入会在历史堆栈中重复记录
            // 所以需要getLocation来判断
            if (me.currentLocation != loc && me.getLocation() != loc || window.location.hash !== '#!' + loc) {
                window.location.hash = '!' + loc;
            }

            me.currentLocation = loc;
            return isChange;
        },
        /**
         * @name 控制定位器转向
         * @public
         * @param {String} loc location位置
         * @param {Object} opt_option 转向参数
         */
        redirect: function (loc, opt_option) {
            var me = hui.Locator,
                opt = opt_option || {},
                hisList,
                histotry = document.getElementById('histotry');

            if (!hui.Locator.hisList) {
                hui.Locator.hisList = [];
            }
            hisList = hui.Locator.hisList;
            hisList.push(loc);

            if (histotry) {
                histotry.innerHTML = hisList.join('<br/>');
            }

            // 非string不做处理
            if (typeof loc != 'string') {
                return;
            }

            // 增加location带起始#号的容错性
            // 可能有人直接读取location.hash，经过string处理后直接传入
            loc = loc.replace(/^#!+/, '').replace(/^#/, '');

            // 空string当成DEFAULT_INDEX处理
            if (loc.length === 0) {
                loc = me.DEFAULT_INDEX;
            }

            // 与当前location相同时不进行route
            var isLocChanged = me.updateLocation(loc);
            if (isLocChanged || opt.enforce) {
                loc = me.currentLocation;

                // 触发onredirect事件
                me.onredirect(loc);

                // 当location未变化，强制刷新时，直接route
                if (isLocChanged === false) {
                    hui.Locator.switchToLocation(loc);
                }
                else {
                    // location被改变了,非强制跳转
                    me.doRoute(loc);
                }
            }
        },
        /**
         * @name 权限判断以及重定向
         * @private
         * @param {String} loc location位置
         */
        doRoute: function (loc) {
            var me = this;
            // 权限判断以及转向
            me.applyFilter(loc, hui.fn(me.doRouteCallback, me, loc));
        },
        doRouteCallback: function (loc) {
            var me = this;
            // ie下使用中间iframe作为中转控制
            // 其他浏览器直接调用控制器方法
            var ie = /msie (\d+\.\d+)/i.test(navigator.userAgent) ? (document.documentMode || +RegExp['\x241']) : undefined;
            if (ie && ie < 8) {
                me.ieRoute(loc);
            }
            else {
                me.switchToLocation(loc);
            }
        },
        /**
         * @name Location变化调用接口
         * @public
         */
        switchToLocation: function (url) {
            var me = this,
                action,
                loc = url;
            // Check url whether illegal.
            if (hui.Router && hui.Router.findAction) {
                // hui.Master.parseLocator(url)
                if (hui.Master && hui.Master.parseLocator) {
                    loc = hui.Master.parseLocator(url);
                    loc = loc ? loc.location : url;
                }
                action = hui.Router.findAction(loc);
                url = action ? url : '/404';
            }
            // checkRouter的过程中可能会改变url
            if (hui.Locator.checkRouter) {
                hui.Locator.checkRouter(url, hui.fn(me.callMasterForward, me));
            }
            else {
                me.callMasterForward(url);
            }
        },
        /**
         * @name 解析获取到的location字符串
         * @private
         * @param {Object} loc
         *
        // 注: 放在Master是因为可能用户会直接使用url而非hashchange来跳转!
        parseLocator: function(url) {...},*/
        /**
         * @name 调用Master的forward接口 注：forward接口不推荐外部直接调用!!
         * @private
         */
        callMasterForward: function (url) {
            if (typeof hui != 'undefined' && hui.Master && hui.Master.forward) {
                hui.Master.forward(url);
            }
        },
        /**
         * @name onredirect事件外部接口
         * @interface
         * @public
         */
        'onredirect': new Function(),
        /**
         * @name 强制刷新当前地址
         * @method
         * @public
         */
        'reload': function () {
            var me = this;
            if (me.currentLocation) {
                me.redirect(me.currentLocation, {
                    enforce: true
                });
            }
        },
        /**
         * @name IE下调用router
         * @method
         * @private
         * @param {String} loc 地址, iframe内容字符串的转义
         */
        ieRoute: function (loc) {
            var me = this;
            var iframe = document.getElementById(me.CONTROL_IFRAME_ID),
                iframeDoc = iframe.contentWindow.document;

            iframeDoc.open('text/html');
            iframeDoc.write(
                me.IFRAME_CONTENT.replace('{{0}}',
                    String(loc).replace(/\\/g, '\\\\').replace(/\"/g, '\\"'))); //'
            iframeDoc.close();

        },
        /**
         * @name 初始化locator
         * @public
         */
        init: function () {
            var me = this,
                ie = /msie (\d+\.\d+)/i.test(navigator.userAgent) ? (document.documentMode || +RegExp['\x241']) : undefined;
            if (ie && ie < 8) {
                me.ieCreateIframeRecorder();
                hui.window.setInterval(function () {
                    me.changeListener();
                }, 100);
            }
            else if ('onhashchange' in hui.window) {
                hui.window.onhashchange = function (args) {
                    me.changeListener(args);
                };
                me.changeListener();
            }
            else {
                hui.window.setInterval(function () {
                    me.changeListener();
                }, 100);
            }
        },
        /**
         * @name hash变化的事件监听器
         * @method
         * @private
         */
        changeListener: function () {
            var me = this,
                loc = me.getLocation();

            if (!loc && !me.currentLocation) {
                me.redirect(me.DEFAULT_INDEX);
            }
            else if (loc && me.updateLocation(loc)) {
                me.doRoute(loc);
            }
        },
        /**
         * @name ie下创建记录与控制跳转的iframe
         * @method
         * @private
         */
        ieCreateIframeRecorder: function () {
            var me = this;
            var iframe = document.createElement('iframe'),
                size = 200,
                pos = '-1000px';

            iframe.id = me.CONTROL_IFRAME_ID;
            iframe.width = size;
            iframe.height = size;
            iframe.src = 'about:blank';

            iframe.style.position = 'absolute';
            iframe.style.top = pos;
            iframe.style.left = pos;

            document.documentElement.appendChild(iframe);
        },
        /**
         * @name 路径权限规则列表
         * @property
         * @type {Array}
         * @default []
         * @public
         */
        filters: [],
        /**
         * @name 增加权限验证器
         * @method
         * @public
         * @param {Function} applyFilterr 验证器，验证失败时验证器返回转向地址
         */
        addFilter: function (rule, target) {
            var me = this;
            if ('function' == typeof target) {
                me.filters.push({
                    rule: rule,
                    target: target
                });
            }
        },
        /**
         * @name 权限验证
         * @method
         * @private
         * @return {String} 验证失败时验证器返回转向地址
         */
        applyFilter: function (url, finish) {
            var filters = [];
            var list = hui.Locator.filters;
            //[优先]匹配单独具体路径
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                if (list[i] && !(list[i].rule instanceof RegExp) && list[i].rule === url) {
                    filters.unshift(list[i].target);
                }
            }
            //匹配所有符合表达式的路径[正则表达式]
            for (var i = list.length - 1; i > -1; i--) {
                if (list[i] && list[i].rule instanceof RegExp && list[i].rule.test(url)) {
                    filters.push(list[i].target);
                }
            }

            this.applyFilterCallback(filters, finish);
        },
        applyFilterCallback: function (filters, finish) {
            if (filters.length) {
                var me = this;
                var filter = filters.shift();
                if (typeof (filter) === 'function') {
                    filter(function () {
                        me.applyFilterCallback(filters, finish);
                    }, finish);
                }
                else {
                    me.applyFilterCallback(filters, finish);
                }
            }
            else {
                finish && finish();
            }
        }
    };

    // firework.addFilter(/^\/admin\//, function (route, next, jump) {
    //     if (!isLogin) {
    //         // 没登录就乖乖去登录
    //         // 通过直接修改路由信息中的`path`来改变实际加载的页面
    //         // 同时添加名为`form`的`query`参数，用于登录完成后跳转回之前的页面
    //         route.query = { from: route.path };
    //         route.path = '/login';
    //         // 直接跳过后续的filter
    //         jump();
    //     }
    //     else {
    //         // 已经登录了
    //         // 就好好继续执行下一个filter吧
    //         next();
    //     }
    // });

    /**
     * @name 预处理流程
     * @public
     * @author wanghaiyang
     * @date 2014/05/05
     */
    hui.Action.start = function () {
        var que = new hui.Flow();

        /**
         * @name before事件外部接口
         * @public
         */
        if (hui.beforeinit) {
            que.push(hui.beforeinit);
        }
        /**
         * @name 载入预定义模板文件
         * @private
         */
        if (hui.Template && hui.Template.loadAllTemplate && hui.Template.TEMPLATE_LIST) {
            que.push(function (callback) {
                hui.Template.onload = callback;
                hui.Template.loadAllTemplate();
            });
        }

        que.push(hui.Template.finishLoad);
        /**
         * @name afterinit事件外部接口，在hui.Template.finishLoad之后执行
         * @public
         */
        if (hui.Action.afterStart) {
            que.push(hui.Action.afterStart);
        }

        que.next();
    };

    hui.Action.afterStart = function (callback) {
        // Todo
        callback();
    };

    /**
     * @name 模板载入完毕之后,初始化路由列表,启动location侦听
     * @private
     */
    hui.Template.finishLoad = function (callback) {
        callback && callback();

        // 1.防止onload再次执行
        if (hui.Template) {
            hui.Template.loadedCount = -100000;
            delete hui.Template.loadedCount;
        }

        // 2.初始化路由列表
        if (hui.Router && hui.Router.init) {
            hui.Router.init();
        }
        // 3.启动location侦听
        if (hui.Locator && hui.Locator.init) {
            // 默认首次进入的路径
            hui.Locator.init();
        }
    };

    /*============================================
     * 404 page
     ============================================*/
    var page404;
    page404 = function () {
        hui.Action.call(this);
        /**
         * @name Action索引ID
         * @comment 主要用于控件中通过onclick="hui.Control.getById('listTable', 'login');
         */
        this.id = 'page404';
        this.parentElement = hui.Action.MAIN_ID;
        // 初始化数据模型
        // 使用了getView这里可以不用设置view属性
        // this.view = 'page404';
        // 初始化数据模型
        var baseModel = hui.Action.getExtClass('hui.BaseModel');
        this.model = new baseModel();
    };

    page404.prototype = {
        getView: function () {
            var str = hui.Control.format([
                '<div style="font-size:10pt;line-height:1.2em; line-height: 1.2em;padding: 15px;text-align: left;background-color: #f1f1f1;">',
                '<button style="display:none" ui="type:\'Button\'">ddd</button><h3 style="margin:0px;line-height:3em;">The page cannot be found</h3>',
                '<p>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>',
                '<p>Please try the following:</p>',
                '<ul><li>If you typed the page address in the Address bar, make sure that it is spelled correctly.<br/></li>',
                '<li>Open the <a href="#!/">home page</a>, and then look for links to the information you want.</li>',
                '<li>Click the <a href="javascript:history.go(-1)">Back</a> button to try another link. </li>',
                '</ul><p><br></p>HTTP 404 - File not found<br />Need any help? Please contact the Monsieur {{name}}.<br /></div>'
            ].join(''), this.querystring);
            return str;
        },
        initModel: function (callback) {
            var me = this;
            me.model.set('free', 'not free');
        },
        initModelAsync: function (callback) {
            //var me = this;
            //me.model.set('free', 'not free');
            callback && callback();
        },
        render: function () {
            //var me = this;
            /*Requester.get('/mockup/user.json', {onsuccess:function(err, data){
                me.setInnerHTML(me, hui.Control.format(me.getInnerHTML(), {name: data.result}));
            }});*/
            // 设置_rendered
            this.getMain().setAttribute('_rendered', 'true');
        },
        /**
         * @name 初始化列表行为
         * @param {Object} cc 当前主内容区域绘制的控件集合.
         */
        initBehavior: function () {
            //var me = this;

        }
    };

    hui.inherits(page404, hui.Action);
    hui.window.page404 = page404;

    //hui.Router.setRule('/404', 'page404');

    hui.Router.setRule('/404', {
        model: new hui.BaseModel(),
        parentElement: hui.Action.MAIN_ID,
        getView: function () {
            var str = hui.Control.format([
                '<div style="font-size:10pt;line-height:1.2em; line-height: 1.2em;padding: 15px;text-align: left;background-color: #f1f1f1;">',
                '<h3 style="margin:0px;line-height:3em;">The page cannot be found</h3>',
                '<p>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>',
                '<p>Please try the following:</p>',
                '<ul><li>If you typed the page address in the Address bar, make sure that it is spelled correctly.<br/></li>',
                '<li>Open the <a href="#!/">home page</a>, and then look for links to the information you want.</li>',
                '<li>Click the <a href="javascript:history.go(-1)">Back</a> button to try another link. </li>',
                '</ul><p><br></p>HTTP 404 - File not found<br />Need any help? Please contact the Monsieur {{user}}.<br /></div>'
            ].join(''), this.querystring);
            return str;
        },
        getViewAsync: function (callback) {
            callback && callback('Hello {{user}}');
        },
        initModelAsync: function (callback) {
            var me = this;
            me.model.set('user', me.querystring.user);
            callback && callback();
        }
    });


});
'::hui_button::';
'use strict';
//   __  __   __  __    _____   ______   ______   __  __   _____     
//  /\ \/\ \ /\ \/\ \  /\___ \ /\__  _\ /\  _  \ /\ \/\ \ /\  __`\   
//  \ \ \_\ \\ \ \ \ \ \/__/\ \\/_/\ \/ \ \ \/\ \\ \ `\\ \\ \ \ \_\  
//   \ \  _  \\ \ \ \ \   _\ \ \  \ \ \  \ \  __ \\ \ . ` \\ \ \ =__ 
//    \ \ \ \ \\ \ \_\ \ /\ \_\ \  \_\ \__\ \ \/\ \\ \ \`\ \\ \ \_\ \
//     \ \_\ \_\\ \_____\\ \____/  /\_____\\ \_\ \_\\ \_\ \_\\ \____/
//      \/_/\/_/ \/_____/ \/___/   \/_____/ \/_/\/_/ \/_/\/_/ \/___/ 
//                                                                   
//                                                                   

/**
 * @name 按钮控件
 * @public
 * @author haiyang5210
 * @date 2014-11-15 19:53
 * @param {Object} options 控件初始化参数.
 */
hui.define('hui_button', ['hui_control'], function () {

    hui.Button = function (options, pending) {
        this.isFormItem = false; // 注：getParamMap时不需要处理button
        hui.Button.superClass.call(this, options, 'pending');

        //进入控件处理主流程!
        if (pending != 'pending') {
            this.enterControl();
        }
    };

    hui.Button.prototype = {
        /**
         * @name button的html模板
         * @private
         */
        tplButton: '<span id="{{2}}" class="{{1}}">{{0}}</span>',

        /**
         * @name 默认的onclick事件执行函数, 不做任何事，容错
         * @public
         */
        onclick: new Function(),

        /**
         * @name 获取button主区域的html
         * @private
         * @return {String}
         */
        getMainHtml: function () {
            var me = this;

            return hui.Control.format(
                me.tplButton,
                me.content || '&nbsp;',
                me.getClass('label'),
                me.getId('label')
            );
        },

        /**
         * @name 渲染控件
         * @public
         */
        render: function () {
            hui.Button.superClass.prototype.render.call(this);
            var me = this,
                main = me.getMain(),
                innerDiv;

            innerDiv = main.firstChild;
            if (!me.content && innerDiv && innerDiv.tagName != 'DIV') {
                me.content = me.getInnerHTML();
            }
            me.setInnerHTML(me, me.getMainHtml());
            // 初始化状态事件
            main.onclick = me.getHandlerClick();
            // 设定宽度
            me.width && (main.style.width = me.width + 'px');
            // 设置disabled
            me.setDisabled(!!me.disabled);
            // 设置_rendered
            main.setAttribute('_rendered', 'true');
        },

        /**
         * @name 获取按钮点击的事件处理程序
         * @private
         * @return {function}
         */
        getHandlerClick: function () {
            var me = this;
            return function (e) {
                if (!me.isDisabled()) {
                    me.onclick();
                }
            };
        },

        /**
         * @name 设置按钮的显示文字
         * @public
         * @param {String} content 按钮的显示文字
         */
        setContent: function (content) {
            this.setInnerHTML(hui.g(this.getId('label'), this.getMain()), content);
            return this;
        },
        /**
         * @name 设置按钮的显示文字
         * @public
         * @param {String} content 按钮的显示文字
         */
        showWaiting: function () {

        }
    };

    /* hui.Button 继承了 hui.Control */
    hui.inherits(hui.Button, hui.Control);

    hui.Control.importCssString(
        '.hui_button { font-family: "microsoft yahei"; background-color: #00aaef; border: 0px; color: white; padding: 6px 30px; border-radius: 30px; font-size: 18px; cursor: pointer; }'
    );

});
'::hui_control::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   

/**
 * @name 控件基础类
 * @public
 * @author wanghaiyang
 * @date 2014/05/05
 */
hui.define('hui_control', [], function () {
    hui.EventDispatcher = function () {
        this._listeners = {};
    };
    hui.EventDispatcher.prototype = {
        /**
         * @name 添加监听器
         * @public
         * @param {String} eventType 事件类型.
         * @param {Function} listener 监听器.
         */
        on: function (eventType, listener) {
            if (!this._listeners[eventType]) {
                this._listeners[eventType] = [];
            }
            var list = this._listeners[eventType],
                exist = false,
                index;

            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i] === listener) {
                    exist = true;
                    index = i;
                    break;
                }
            }
            if (!exist) {
                this._listeners[eventType].push(listener);
                index = this._listeners[eventType].length - 1;
            }
            return index;
        },

        /**
         * @name 移除监听器
         * @public
         * @param {String} eventType 事件类型.
         * @param {Function} listener 监听器.
         */
        off: function (eventType, listener) {
            if (!this._listeners[eventType]) {
                return;
            }
            var list = this._listeners[eventType];

            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i] === listener || i === listener) {
                    this._listeners[eventType][i] = undefined;
                    break;
                }
            }
            if (listener === undefined) {
                this._listeners[eventType] = [];
            }
        },
        /**
         * @name 清除所有监听器
         * @public
         */
        clear: function (eventType) {
            // 清除全部
            if (!eventType) {
                this._listeners = [];
            }
            // 只清除指定类型
            else if (this._listeners[eventType]) {
                this._listeners[eventType] = [];
            }
            else if (Object.prototype.toString.call(eventType) === '[object Array]') {
                for (var i = 0, len = eventType.length; i < len; i++) {
                    this.clear(eventType[i]);
                }
            }
        },
        /**
         * @name 触发事件
         * @public
         * @param {String} eventType 事件类型.
         */
        trigger: function (eventType) {
            if (!this._listeners[eventType]) {
                return;
            }
            var args = [];
            for (var i = 1; i < arguments.length; i++) {
                args.push(arguments[i]);
            }
            var list = this._listeners[eventType];
            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i]) {
                    list[i].apply(this, args);
                }
            }
        }
    };
    hui.EventDispatcher.prototype.constructor = hui.EventDispatcher;

    hui.Flow = function () {
        var me = this;
        me.que = [hui.fn(me.endFlow, me)]; // 注：存放要调用的函数列表
        me.id = hui.Flow.getIndex(); // 注：仅用于标示，不会被调用（即使删掉也没什么影响）
        me.parentflow = [];
        /**  
         * @name 开始执行异步队列
         * @param {Function} callback 嵌套时的回调函数，其实就是hui.Flow.prototype.next
         * @return {void}
         */
        me.next = function (callback) {
            var args = [].slice.call(arguments, 0);

            // console.log(me.id);
            if (me.que.length > 0) {
                var fn = me.que.shift();
                fn.apply(null, args);
            }
        };
        me.next._isFlowPrivate = hui.Flow.getIdentity();
        me.next.mainFlow = me;

    };
    hui.Flow.getIdentity = (function () {
        var guid = new Date().toString() + Math.random();
        return function (formname) {
            return guid;
        };
    })();
    hui.Flow.getIndex = (function () {
        var guid = 1;
        return function (formname) {
            return guid++;
        };
    })();
    /**  
     * @name 添加需要异步执行的函数
     * @param {Function} fn 需要异步执行的函数
     * @return {this} 返回主体以便于后续操作
     */
    hui.Flow.prototype.push = function (fn) {
        var me = this;

        if (fn && fn._isFlowPrivate === hui.Flow.getIdentity()) {
            var endFlow = me.que.pop();
            me.que.push(fn);
            me.que.push(endFlow);
            if (fn.mainFlow) {
                fn.mainFlow.parentflow.push(me);
            }
        }
        else {
            var callback = hui.fn(me.next, me);
            callback._isFlowPrivate = hui.Flow.getIdentity();

            var endFlow = me.que.pop();
            me.que.push(function () {
                fn.apply(me, [callback].concat([].slice.call(arguments, 0)));
            });
            me.que.push(endFlow);
        }

        return me;
    };
    hui.Flow.prototype.endFlow = function () {
        var me = this;
        if (me.parentflow) {
            while (me.parentflow.length) {
                me.parentflow.pop().next();
            }
        }
    };

    /**  
     * @name Javascript简单异步框架 
     * @property {Array} que 保存回调队列  
     * @method {Function} push 添加需要异步执行的函数
     * @method {Function} next 开始执行异步队列
     * @comment 异步队列中的函数需要实现callback的接口
     * @example
         function doit() {
            alert('a');
            
            var que1 = new hui.Flow();
            que1.push(a);
            que1.push(d); 
            setTimeout(function(){
                que1.next();
            },400);
        }

         function a(callback) {
            alert('a');
            
            var que2 = new hui.Flow();
            que2.push(b).push(c).push(callback); 
            
            setTimeout(function(){
                que2.next();
            },400);
        }
        function b(callback) {
            alert('b');
            callback&&callback();
        }
        function c(callback) {
            alert('c');
            callback&&callback();
        }
     */

    // Define hui_control
    hui.Control = function (options, pending) {
        hui.EventDispatcher.call(this);

        // 状态列表
        options = options || {};
        // 初始化参数
        this.initOptions(options);
        // 生成控件id
        if (!this.id) {
            this.id = hui.Control.makeGUID(this.formname);
        }

        hui.Control.appendControl(options.parentControl, this);

        // 子类调用此构造函数不可以立即执行!!只能放在子类的构造函数中执行!否则实例化时找不到子类中定义的属性!
        // 进入控件处理主流程!
        if (pending != 'pending') {
            this.enterControl();
        }
    };

    hui.Control.prototype = {
        /**
         * @name 初始化参数
         * @protected
         * @param {Object} options 参数集合
         */
        initOptions: function (options) {
            for (var k in options) {
                if (options.hasOwnProperty(k)) {
                    this[k] = options[k];
                }
            }
        },
        // 注: childControl不能放在这里,放在这里会导致"原型继承属性只是用一个副本的坑"!!
        // cc: [],
        /**
         * @name 获取dom子部件的css class
         * @protected
         * @return {String}
         */
        getClass: function (opt_key) {
            if (!this.type) {
                return '';
            }

            var me = this,
                type = String(me.type).toLowerCase(),
                className = 'hui_' + type,
                skinName = 'skin_' + type + '_' + me.skin;

            if (opt_key) {
                className += '_' + opt_key;
                skinName += '_' + opt_key;
            }

            if (me.skin) {
                className = skinName + ' ' + className;
            }

            return className;
        },

        /**
         * @name 获取dom子部件的id
         * @public
         * @return {String}
         */
        getId: function (key) {
            var me = this,
                // uiAttr = hui.Control.UI_ATTRIBUTE || 'ui';
                // idPrefix = 'ctrl' + this.type + this.id;
                idPrefix = me.id === undefined ? '' : me.id;

            if (key) {
                idPrefix = idPrefix + key;
            }
            return idPrefix;
        },
        /**
         * @name 获取控件的elem(nodejs). 注:控件即使不需要显示任何内容也必须有一个挂载的elem(可以是隐藏的),
         * 通过模板解析控件时会用到 [nodejs&browser]
         * @public
         * @return {String}
         */
        getMain: function () {
            var me = this,
                elem;
            elem = me.main ? document.getElementById(me.main) : null;
            return elem;
        },
        mainFocus: function () {
            // Fix IE8 bug: hidden elem focus() cause error
            var main = this.getMain();
            try {
                main.focus();
            }
            catch (e) {}
        },
        /**
         * @name 获取控件的innerHTML
         * @public
         * @param {HTMLElement} elem 默认为控件主DOM[可选]
         * @return {String}
         */
        getInnerHTML: function (elem) {
            var me = this,
                elem = elem || me.getMain(),
                html = '';
            if (elem.getInnerHTML) {
                html = elem.getInnerHTML();
            }
            else if (elem.innerHTML !== undefined) {
                html = elem.innerHTML;
            }
            return html;
        },
        /**
         * @name 设定控件的innerHTML[nodejs&browser]
         * @public
         * @param {String} html innerHTML
         * @param {HTMLElement} elem 默认为控件主DOM[可选]
         * @return {String}
         */
        setInnerHTML: function (elem, html) {
            if (!html && typeof elem === 'string' && this.getMain) {
                html = elem;
                elem = this.getMain();
            }
            return hui.Control.setInnerHTML(elem, html);
        },
        /**
         * @name 渲染控件
         * @public
         */
        render: function () {
            // var me = this;
            // var main = me.getMain();
            // var data = me.model && me.model.getData && typeof me.model.getData === 'function' ? me.model.getData() : {};
            // hui.Control.init(main, data, me);
            // main.setAttribute('_rendered', 'true');
        },
        // 
        /**
         * @name 生成HTML
         * @public
         */
        // initView: function (callback) {
        //     callback && callback();
        // },
        /**
         * @name 绑定事件
         * @public
         */
        initBehavior: function () {
            //var me = this;
        },
        initBehaviorByTree: function () {
            var me = this,
                main = me.getMain();
            if (me.cc) {
                for (var i = 0, len = me.cc.length; i < len; i++) {
                    me.cc[i].initBehaviorByTree();
                }
            }
            if (main && main.getAttribute('_initbehavior') != 'true') {
                main.setAttribute('_initbehavior', 'true');
                me.initBehavior();
            }
        },
        /**
         * @name 验证控件的值
         * @public
         */
        validate: function (show_error) {
            var me = this,
                result = true,
                cc = me.cc,
                Validator = hui.Control.getExtClass('hui.Validator'),
                c,
                list,
                m,
                n;

            if (me.rule && !me.isDisabled()) {
                result = false;
                list = String(me.rule).split('||');
                for (var i = 0, len = list.length; i < len && !result; i++) {
                    c = true;
                    m = list[i].split('&&');
                    for (var j = 0, len2 = m.length; j < len2; j++) {
                        n = m[j];
                        c = c && Validator.applyRule(me, n, show_error);
                    }
                    result = result || c;
                }
            }
            // result ===  null
            if (!me.rule && cc && !me.isDisabled()) {
                result = true;
                m = null;
                for (var i = 0, len = cc.length; i < len; i++) {
                    n = cc[i].validate(show_error);
                    result = n && result;
                    m = m === null && !n ? cc[i] : m;
                }
                //m && m.getInput && m.getInput() && m.getInput().focus();
            }

            return result;
        },
        hideError: function () {
            var me = this,
                Validator = hui.Control.getExtClass('hui.Validator');
            Validator.cancelNotice(me.getMain());
            if (me.cc) {
                for (var i = 0, len = me.cc.length; i < len; i++) {
                    me.cc[i].hideError();
                }
            }
            return me;
        },
        showError: function (errorMsg, code) {
            var me = this,
                Validator = hui.Control.getExtClass('hui.Validator'),
                rule = Validator.getRule(me.rule);
            if (rule && code === 'by_code') {
                errorMsg = rule.noticeText[errorMsg];
            }

            Validator.showError(me.getMain(), errorMsg);
            return me;
        },
        showErrorByTree: function (paramMap, code) {
            var me = this,
                value,
                list,
                ctr;
            if (me.cc && paramMap) {
                for (var formname in paramMap) {
                    if (formname && paramMap.hasOwnProperty(formname)) {
                        value = Object.prototype.toString.call(paramMap[formname]) !== '[object Array]' ?
                            [paramMap[formname]] : paramMap[formname];
                        list = me.getByFormnameAll(formname, false);
                        if (list.length < 1) {
                            continue;
                        }
                        for (var i = 0, len = value.length; i < len; i++) {
                            ctr = list[i];
                            if (ctr) {
                                if (Object.prototype.toString.call(value[i]) === '[object Object]' &&
                                    ctr.cc) {
                                    ctr.showErrorByTree(value[i], code);
                                }
                                else if (ctr.showError) {
                                    ctr.showError(value[i], code);
                                }
                                ctr = null;
                            }
                        }
                    }
                }
            }
            return me;
        },
        showOK: function () {
            var me = this,
                Validator = hui.Control.getExtClass('hui.Validator');
            Validator.showOK(me);
            return me;
        },
        showWaiting: function () {
            var me = this,
                Validator = hui.Control.getExtClass('hui.Validator');
            Validator.showWaiting(me);
            return me;
        },
        /**
         * @name 返回控件的值
         * @public
         */
        //getValue:   new Function(), // 注: 控件直接返回值(对象/数组/字符串)时才能使用getValue! 获取所有子控件的值,应该用getParamMap
        setValue: function (paramMap) {
            var me = this;
            if (me.cc && (/\[object Object\]/.test(Object.prototype.toString.call(paramMap)))) {
                me.setValueByTree(this.value);
            }
            else {
                // 注：在setValue/getValue时不允许使用me.getMain().setAttirbute('value', value)和me.getMain()
                // .getAttirbute('value'),因为value有可能是数组/对象！！
                // 如果确定value是num或str可以在子类中覆盖setValue/getValue！！
                me.getMain().value = paramMap;
            }
            return me;
        },
        /**
         * @name 给控件树一次性赋值
         * @param {Object} v 值
         */
        setValueByTree: function (paramMap) {
            var me = this,
                value,
                list,
                ctr,
                main;
            if (me.cc && paramMap) {
                for (var formname in paramMap) {
                    if (formname && paramMap.hasOwnProperty(formname)) {
                        value = Object.prototype.toString.call(paramMap[formname]) !== '[object Array]' ?
                            [paramMap[formname]] : paramMap[formname];
                        list = me.getByFormnameAll(formname, false);
                        if (list.length < 1) {
                            continue;
                        }
                        for (var i = 0, len = list.length; i < len; i++) {
                            ctr = list[i];

                            if (ctr.constructor &&
                                ctr.setValue &&
                                ctr.getPresetValue) {
                                var presetValue = ctr.getPresetValue();
                                for (var j = 0, len2 = value.length; j < len2; j++) {
                                    if (value[j] && presetValue === String(value[j])) {
                                        ctr.setValue(value[j]);
                                        break;
                                    }
                                }
                            }
                            else if (ctr.constructor &&
                                ctr.setValue &&
                                ctr.setValue !== hui.Control.prototype.setValue) {
                                ctr.setValue(value[i]);
                            }
                            else if (ctr.cc) {
                                ctr.setValueByTree(value[i]);
                            }
                            else if (ctr.getMain || ctr.main) {
                                main = (ctr.getMain ? ctr.getMain() : document.getElementById(ctr.main)) || {};
                                main.value = value[i];
                            }

                            ctr = null;
                        }
                    }
                }
            }

            return me;
        },
        getValue: function () {
            var me = this,
                main = me.getMain ? me.getMain() : document.getElementById(me.main),
                value = main.value;
            if (me.cc) {
                value = me.getParamMap();
            }
            return value;
        },
        /**
         * @name 获取子控件的值，返回一个map
         * @public
         */
        getParamMap: function () {
            var me = this,
                paramMap = {},
                ctr,
                formname,
                value,
                groupList = {};
            // 如果有子控件建议递归调用子控件的getValue!!
            if (me.cc) {
                for (var i = 0, len = me.cc.length; i < len; i++) {
                    ctr = me.cc[i];
                    formname = hui.Control.prototype.getFormname.call(ctr);
                    groupList[formname] = !!ctr.group;
                    if (String(ctr.isFormItem) !== 'false') {
                        paramMap[formname] = paramMap[formname] ? paramMap[formname] : [];
                        if (ctr.getValue) {
                            value = ctr.getValue();
                            paramMap[formname].push(value);
                        }
                        else if (ctr.getMain || ctr.main) {
                            value = (ctr.getMain ? ctr.getMain() : document.getElementById(ctr.main)).value;
                            paramMap[formname].push(value);
                        }
                        else if (ctr.cc) {
                            value = ctr.getParamMap();
                            paramMap[formname].push(value);
                        }
                    }

                }
                // 注：默认都用数组包装，此处还原为值
                for (var i in paramMap) {
                    if (paramMap[i] && paramMap[i].length < 2) {
                        paramMap[i] = paramMap[i][0] !== undefined ? (groupList[i] ? paramMap[i] : paramMap[i][0]) : '';
                    }
                }
            }

            return paramMap;
        },
        /**
         * @name 通过formname访问子控件
         * @public
         * @param {String} formname 子控件的formname
         */
        getByFormname: function (formname) {
            var me = this;
            return hui.Control.getByFormname(formname, me);
        },
        getByFormnameAll: function (formname, all) {
            var me = this;
            return hui.Control.getByFormnameAll(formname, me, all);
        },
        /**
         * @name 显示控件
         * @public
         */
        show: function () {
            this.getMain().style.display = 'block';
            hui.Control.removeClass(this.getMain(), 'hide');
            return this;
        },

        /**
         * @name 隐藏控件
         * @public
         */
        hide: function () {
            hui.Control.addClass(this.getMain(), 'hide');
            this.getMain().style.display = 'none';
            return this;
        },
        /**
         * @name 设置控件不可用状态
         * @public
         * @param {Boolean} disabled
         */
        setDisabled: function (disabled) {
            var me = this,
                main = me.getMain();
            main.disabled = typeof disabled === 'undefined' ? disabled = true : disabled;

            if (main.disabled) {
                hui.Control.addClass(main, me.getClass('disabled'));
            }
            else {
                hui.Control.removeClass(main, me.getClass('disabled'));
            }
            return me;
        },
        /**
         * @name 设置控件不可用状态
         * @public
         * @param {Boolean} disabled
         */
        setReadonly: function (readOnly) {
            if (typeof readOnly === 'undefined') {
                readOnly = true;
            }
            this.getMain().readOnly = readOnly;
            return this;
        },
        /**
         * @name 判断控件不可用状态
         * @public
         * @return {boolean}
         */
        isDisabled: function () {
            return this.getMain().disabled;
        },
        isReadonly: function () {
            return this.getMain().readOnly;
        },
        /**
         * @name 设置控件width和height
         * @public
         */
        setSize: function (size) {
            var me = this,
                main = me.getMain();
            me.size = size ? size : me.size || {};
            me.size.width = me.size.width === undefined ? me.size.w : me.size.width;
            me.size.height = me.size.height === undefined ? me.size.h : me.size.height;
            me.size.top = me.size.top === undefined ? me.size.t : me.size.top;
            me.size.bottom = me.size.bottom === undefined ? me.size.b : me.size.bottom;
            me.size.left = me.size.left === undefined ? me.size.l : me.size.left;
            me.size.right = me.size.right === undefined ? me.size.r : me.size.right;

            if (me.size && me.size.width) {
                main.style.width = me.size.width + (typeof me.size.width !== 'string' ? 'px' : '');
            }
            if (me.size && me.size.height) {
                main.style.height = me.size.height + (typeof me.size.height !== 'string' ? 'px' : '');
            }

            if (me.size && me.size.top) {
                main.style.top = me.size.top + (typeof me.size.top !== 'string' ? 'px' : '');
            }
            if (me.size && me.size.bottom) {
                main.style.bottom = me.size.bottom + (typeof me.size.bottom !== 'string' ? 'px' : '');
            }
            if (me.size && me.size.left) {
                main.style.left = me.size.left + (typeof me.size.left !== 'string' ? 'px' : '');
            }
            if (me.size && me.size.right) {
                main.style.right = me.size.right + (typeof me.size.right !== 'string' ? 'px' : '');
            }
        },
        /**
         * @name 获取表单控件的表单名
         * @public
         * @param {Object} control
         */
        getFormname: function () {
            var me = this,
                main = me.getMain ? me.getMain() : document.getElementById(me.main);
            var itemName = me.formname || me['name'] || (main ? main.getAttribute('name') : null);
            return itemName;
        },
        /**
         * @name 释放控件
         * @protected
         */
        dispose: function () {
            var me = this,
                cc,
                main = me.getMain ? me.getMain() : document.getElementById(me.main),
                list;
            // 从父控件的childControl中删除引用
            if (me.parentControl) {
                cc = me.parentControl.cc;
                for (var i = 0, len = cc.length; i < len; i++) {
                    if (cc[i] === me) {
                        cc.splice(i, 1);
                        break;
                    }
                }
            }

            me.disposeChild && me.disposeChild();

            if (main) {
                // 释放控件主区域的常用事件
                list = 'onmouseover|onmouseout|onmousedown|onmouseup|onkeyup|onkeydown|onkeypress|onchange|onpropertychange|' +
                    'onfocus|onblur|onclick|ondblclick|ontouchstart|ontouchmove|ontouchend|ondragover|ondrop|ondragstart'.split('|');
                for (var i = 0, len = list.length; i < len; i++) {
                    try {
                        main[list[i]] = Function('');
                    }
                    catch (e) {}
                }

                // 清空HTML内容
                if (main.setInnerHTML) {
                    main.setInnerHTML(main, '');
                }
                else if (main.innerHTML) {
                    main.innerHTML = '';
                }
                main.parentNode.removeChild(main);
            }

            // 因为使用的属性而非闭包实现的EventDispatcher，因此无需担心内存回收的问题。
        },
        disposeChild: function () {
            var me = this;
            // dispose子控件
            if (me.cc) {
                for (var i = me.cc.length - 1; i > -1; i--) {
                    me.cc[i].dispose();
                    me.cc[i] = null;
                }
                me.cc = [];
            }
        },
        // /**
        //  * @name 获取视图模板名
        //  * @protected
        //  * @return {String} target名字
        //  * @default 默认为action的id
        //  */
        // getView: function () {
        //     var view = (this.view === null ? '' : this.view);
        //     // 获取view
        //     if (typeof view === 'function') {
        //         view = view();
        //     }
        //     view = hui.Control.getExtClass('hui.Template').getTarget(String(view));

        //     return view;
        // },
        /**
         * @name Control的主要处理流程
         * @protected
         * @param {Object} argMap arg表.
         */
        enterControl: function (callback) {
            var uiObj = this,
                parentControl = uiObj.parentControl;
            // 注：默认增加一个空元素作为控件主元素!
            if (typeof uiObj.getMain !== 'function') {
                uiObj.getMain = hui.Control.prototype.getMain;
            }
            var elem = uiObj.getMain() || (uiObj.createMain ? uiObj.createMain() : hui.Control.prototype.createMain.call(uiObj));
            if (!elem) {
                return hui.Control.error('Control\'s main element is invalid');
            }
            else {
                elem.setAttribute('_rendered', '');
                elem.setAttribute('_initbehavior', '');
            }

            var que = new hui.Flow(); // 注：可以参照hui_flow.js文件。非常简单，不到30行代码
            if (elem.getAttribute && !elem.getAttribute('ctrid')) {
                que.push(function (next) {
                    var me = uiObj;
                    var main = me.getMain();
                    // 默认设置value
                    if (uiObj.value !== undefined) {
                        main.value = uiObj.value;
                    }
                    // 便于通过main.getAttribute('ctrid')找到control
                    main.setAttribute('ctrid', uiObj.getId ? uiObj.getId() : uiObj.id);
                    me.getClass && hui.Control.addClass(main, me.getClass());
                    me.setSize && me.setSize();

                    next && next();
                });
            }

            // 初始化Model
            if (elem.getAttribute && elem.getAttribute('_initModel') != 'true') {
                if (uiObj.initModel && uiObj.initModelMethod !== 'async' && uiObj.initModelMethod !== 'skip') {
                    que.push(function (next) {
                        var me = uiObj;
                        me.initModel();

                        next && next();
                    });
                    que.push(function (next) {
                        var me = uiObj;
                        var main = me.getMain();
                        main.getAttribute('_initModel', 'true');
                        next && next();
                    });
                }
                else if (uiObj.initModelAsync && uiObj.initModelMethod !== 'sync' && uiObj.initModelMethod !== 'skip') {
                    que.push(function (next) {
                        uiObj.initModelAsync();
                        next && next();
                    });
                    que.push(function (next) {
                        var me = uiObj;
                        var main = me.getMain();
                        main.getAttribute('_initModel', 'true');
                        next && next();
                    });
                }
            }

            // 渲染视图
            if (elem.getAttribute && elem.getAttribute('_initView') != 'true') {
                if (uiObj.getView && uiObj.getViewMethod !== 'async' && uiObj.getViewMethod !== 'skip') {
                    que.push(function (next) {
                        var me = uiObj;
                        var main = me.getMain();
                        var tpl = me.getView();
                        var mainHTML = me.model && me.model.getData ? hui.Control.getExtClass('hui.Template').merge(tpl, me.model.getData()) : tpl;
                        hui.Control.prototype.setInnerHTML(main, mainHTML);

                        next && next();
                    });
                    que.push(function (next) {
                        var me = uiObj;
                        var main = me.getMain();
                        main.getAttribute('_initView', 'true');
                        next && next();
                    });
                }
                else if (uiObj.getViewAsync && uiObj.getViewMethod !== 'sync' && uiObj.getViewMethod !== 'skip') {
                    que.push(function (next) {
                        var me = uiObj;
                        me.getViewAsync(function (tpl) {
                            var main = me.getMain();
                            var mainHTML = me.model && me.model.getData ? hui.Control.getExtClass('hui.Template').merge(tpl, me.model.getData()) : tpl;
                            hui.Control.prototype.setInnerHTML(main, mainHTML);

                            next && next();
                        });
                    });
                    que.push(function (next) {
                        var me = uiObj;
                        var main = me.getMain();
                        main.getAttribute('_initView', 'true');

                        next && next();
                    });
                }
            }

            que.push(function (next) {
                var me = uiObj;
                var main = me.getMain();
                // 动态生成control需手动维护me.parentControl
                // 回溯找到父控件,若要移动控件,则需手动维护parentControl属性!!
                var parentElement = main;
                while (parentElement && parentElement.tagName && parentElement.parentNode) {
                    parentElement = parentElement.parentNode;
                    //label标签自带control属性!!
                    if (parentElement && hui.Control.isControlMain(parentElement)) {
                        var control = hui.Control.getById(parentElement.getAttribute('ctrid'), parentControl);
                        hui.Control.appendControl(control, me);
                        break;
                    }
                    // 未找到直接父控件则将control从hui.window.childControl移动到action.childControl中
                    else if (~',html,body,'.indexOf(',' + String(parentElement.tagName).toLowerCase() + ',')) {
                        hui.Control.appendControl(null, me);
                        break;
                    }
                }
                next && next();
            });

            // 1. initView()会在render调用父类的render时自动调用，
            // 2. 不管是批量hui.Control.init()还是hui.Control.create(), 都会通过enterControl来执行render
            // 3. initBehavior()会在后面执行
            if (elem.getAttribute && elem.getAttribute('_rendered') != 'true') {
                que.push(function (next) {
                    var me = uiObj;
                    var main = me.getMain();
                    me.render && me.render();

                    if (!me.render || main.getAttribute('_rendered') === 'false') {
                        var data = me.model && me.model.getData && typeof me.model.getData === 'function' ? me.model.getData() : {};
                        hui.Control.init(main, data, me);
                        main.setAttribute('_rendered', 'true');
                    }

                    next && next();
                });
            }
            if (elem.getAttribute && elem.getAttribute('_initbehavior') != 'true') {
                que.push(function (next) {
                    var me = uiObj;
                    if (me.initBehaviorByTree) {
                        me.initBehaviorByTree();
                    }
                    else if (me.initBehavior) {
                        me.initBehavior();
                    }

                    next && next();
                });
            }
            que.push(function (next) {
                var me = uiObj;
                me.finish && me.finish();

                callback && callback();
            });

            que.next();
        },
        /**
         * @name 生成DOM
         * @protected
         */
        createMain: function () {
            var me = this,
                tagName = this.tagName || 'DIV',
                main = document.createElement(String(tagName).toUpperCase()),
                control = me.parentControl,
                wrap = null;

            if (!wrap && control && control.getMain) {
                wrap = control.getMain();
            }
            if (!wrap && control && control.main) {
                wrap = document.getElementById(control.main);
            }
            if (!wrap) {
                wrap = document.body || document.documentElement;
            }
            if (me.parentElement) {
                wrap = typeof me.parentElement === 'string' ? document.getElementById(me.parentElement) : me.parentElement;
            }

            wrap.appendChild(main);

            main.id = hui.Control.makeElemGUID(me.id);
            me.main = main.id;

            return main;
        },
        /**
         * @name 父控件添加子控件. 注: 将子控件加到父控件下面的容器中也可以调用appendSelfTo
         * @public
         * @param {Control} uiObj 子控件.
         */
        appendControl: function (uiObj) {
            return hui.Control.appendControl(this, uiObj);
        }
    };

    hui.inherits(hui.Control, hui.EventDispatcher);

    /**
     * @name 获取唯一id
     * @public
     * @return {String}
     */
    hui.Control.makeGUID = (function () {
        var guid = 1;
        return function (formname) {
            return (formname ? formname : 'inner') + '_' + hui.Control.getHashCode('inner') + (guid++);
        };
    })();

    hui.Control.getHashCode = function (str) {
        var hash = 0;
        if (str.length === 0) return hash;
        for (var i = 0; i < str.length; i++) {
            var c = str.charCodeAt(i);
            hash = ((hash << 5) - hash) + c;
            hash = hash & hash; // Convert to 32bit integer
        }
        return hash;
    };

    /**
     * @name 获取唯一id
     * @public
     * @return {String}
     */
    hui.Control.makeElemGUID = (function () {
        var guid = 1;
        return function (id) {
            return (id !== undefined ? id + hui.Control.getHashCode(id) : ('_' + hui.Control.formatDate(new Date(), 'yyyyMMddHHmm') + '_' + (guid++)));
        };
    })();
    /**
     * @name 解析自定义ui属性
     * @public
     * @param {String} attrStr ui属性
     * @param {Hashmap} opt_propMap 数据model
     * @return {Hashmap}
     */
    hui.Control.parseCustomAttribute = function (attrStr, opt_propMap) {
        var attrStr = '{' + (attrStr || '') + '}',
            attrs,
            attrValue,
            attrName;

        // 解析ui属性
        attrs = (new Function('return ' + attrStr))();

        for (var j in attrs) {
            if (attrs.hasOwnProperty(j)) {
                // 通过@定义的需要到传入的model中找
                attrValue = attrs[j];
                if (attrValue && typeof attrValue == 'string' && attrValue.indexOf('@') === 0) {
                    attrName = attrValue.substr(1);

                    attrValue = opt_propMap && opt_propMap.get ? opt_propMap.get(attrName) : opt_propMap[attrName];
                    // 默认读取opt_propMap中的,没有再到全局context中取,防止强耦合.
                    if (attrValue === undefined) {
                        attrValue = hui.Control.getExtClass('hui.context').get(attrName);
                    }
                    attrs[j] = attrValue;
                }
            }
        }

        return attrs;
    };

    /**
     * @name 判断一个解析前DOM元素是否是子控件，是则跳过非父控件的hui.Control.init()
     * @public
     * @param {String} elem DOM元素
     */
    hui.Control.isChildControl = function (elem, list) {
        var result = false;
        // 回溯找到父控件,若要移动控件,则需手动维护parentControl属性!!
        while (elem && elem.tagName && elem.parentNode) {
            elem = elem.parentNode;
            if (~',html,body,'.indexOf(',' + String(elem.tagName).toLowerCase() + ',') == -1) break;
            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i] == elem) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    };

    /**
     * @name 判断一个解析前DOM元素是否已解析控件
     * @public
     * @param {String} elem DOM元素
     */
    hui.Control.isControlMain = function (elem) {
        var result = false;
        // label的control是DOM
        if (elem && elem.getAttribute && elem.getAttribute('ctrid')) {
            result = true;
        }
        return result;
    };

    /**
     * @name 批量生成控件
     * @public
     * @param {HTMLElement} opt_wrap 渲染的区域容器元素
     * @param {Object}      opt_propMap 控件需要用到的数据Model{@key}
     * @param {Object}      parentControl 渲染的action,不传则默认为window对象
     * @return {Object} 控件集合
     */
    //hui.Control.init('<div ui="type:"></div>');//暂时禁止此方法生成控件树
    //hui.Control.init(hui.bocument.getElementById('content'));
    hui.Control.init = function (opt_wrap, opt_propMap, parentControl) {
        if (!opt_wrap || opt_wrap.getAttribute('_rendered') === 'true') {
            return false;
        }

        /*Step 1: 转换string到DOM
    // 容器为空的判断
    if (typeof (opt_wrap) == 'string') {
        hui.bocument.documentElement.setInnerHTML(elem, opt_wrap);
        opt_wrap = hui.bocument.documentElement;
    }*/

        /*Step 2: 转换DOM到control*/
        opt_propMap = opt_propMap || {}; // 这里并不会缓存BaseModel，因此销毁空间时无须担心BaseModel
        // parentControl不传默认为window对象
        parentControl = parentControl || hui.window;
        parentControl.cc = parentControl.cc || [];


        var uiAttr = hui.Control.UI_ATTRIBUTE || 'ui';
        var realEls = [],
            uiEls = [];
        var elem, control;

        // 把dom元素存储到临时数组中
        // 控件渲染的过程会导致elements的改变
        realEls = hui.Control.findAllNodes(opt_wrap);

        // 循环解析自定义的ui属性并渲染控件
        // <div ui="type:'UIType',id:'uiId',..."></div>
        for (var i = 0, len = realEls.length; i < len; i++) {
            elem = realEls[i];
            if (elem && elem.getAttribute && (elem.getAttribute(uiAttr) || elem.getAttribute('hui-type')) && (elem.getAttribute('_initview') !== 'true' || elem.getAttribute('_initbehavior') !== 'true')) {
                uiEls.push(elem);
            }
        }
        for (var i = 0, len = uiEls.length; i < len; i++) {
            elem = uiEls[i];
            if (!hui.Control.isChildControl(elem, uiEls) && elem.getAttribute('_rendered') !== 'true') {

                control = hui.Control.create(elem, {
                    parentControl: parentControl
                });

                /*var attrStr = elem.getAttribute(uiAttr);
            
            var attrs = hui.Control.parseCustomAttribute(attrStr, opt_propMap);
            
            // 主元素参数初始化
            if(attrs.main          == undefined && elem)          {attrs.main = elem.id ? elem.id : hui.Control.makeElemGUID(); elem.id = attrs.main;}
            if(attrs.parentControl == undefined && parentControl) {attrs.parentControl = parentControl;}
            // 生成控件 //这里的parentControl, elem不能去掉!!否则在后面的enterControl理会重复生成elem!!! 
            //control = hui.Control.create( options[ 'type' ], options, parentControl, elem);
            //放在了上上一行,故去掉了parentControl, elem
             
            control = hui.Control.create( attrs[ 'type' ], attrs);
            /**
             * 保留ui属性便于调试与学习
             */
                // elem.setAttribute( uiAttr, '' );
            }
        }

        return parentControl.cc;
    };

    /**
     * @name 创建一个控件对象
     * @public
     * @param {String} type 控件类型
     * @param {Object} options 控件初始化参数
     * @return {hui.Control} 创建的控件对象
     */
    hui.Control.create = function (type, options) {
        // 注：扩展了一下，直接支持hui.Control.create(Element);
        if (type && Object.prototype.toString.call(type) != '[object String]' && type.getAttribute) {
            options = options || {};
            if (hui.Control.isControlMain(type)) {
                var control = hui.Control.getById(type.getAttribute('ctrid'));
                if (control) {
                    hui.Control.appendControl(options.parentControl, control);
                }
            }
            var str, attrs;
            try {
                str = type.getAttribute(hui.Control.UI_ATTRIBUTE || 'ui');
                try {
                    attrs = hui.Control.parseCustomAttribute(str);
                }
                catch (e) {
                    attrs = hui.Control.parseCustomAttribute(str.replace(/\\\'/g, '\'').replace(/\\\"/g, '\"')); //"
                }
                // hui-type="TextInput"
                var list = type.attributes;
                for (var i = 0, len = list.length; i < len; i++) {
                    var item = list[i];
                    if (item.nodeName.indexOf('hui-') === 0) {
                        attrs[item.nodeName.replace('hui-', '')] = item.nodeValue;
                    }
                }
            }
            catch (e) {
                hui.window.JSON && hui.window.JSON.stringify && hui.window.console && hui.window.console.error && hui.window.console.error('JSON Error: ', str);
                return;
            }

            var text, action, key;
            for (var i in attrs) {
                text = attrs[i];
                if (text && Object.prototype.toString.call(text) === '[object String]') {
                    if (text.indexOf('&') === 0) {
                        key = text.replace('&', '');
                        attrs[i] = hui.window[key];
                    }
                    else if (text.indexOf('@') === 0 && hui.Action && (typeof hui.Master.get) === 'function') {
                        key = text.replace('&', '');
                        action = hui.Master.get();
                        if (action && action.model && (typeof action.model.get) === 'function') {
                            attrs[i] = action.model.get(key);
                        }
                        else if (action && action.model) {
                            attrs[i] = action.model[key];
                        }
                        else if (action) {
                            attrs[i] = action[key];
                        }

                    }
                }
            }

            for (var i in options) {
                if (i && options.hasOwnProperty(i)) {
                    attrs[i] = attrs[i] !== undefined ? attrs[i] : options[i];
                }
            }
            // 注：每个控件必须有id
            attrs.id = attrs.id ? attrs.id : hui.Control.makeGUID(attrs['formname']);
            // 注：type即elem
            type.id = type.id || hui.Control.makeElemGUID(attrs.id);
            attrs.main = type.id;
            attrs.bocument = type.bocument;

            return hui.Control.create(attrs['type'], attrs);
        }

        options = options || {};

        // 注：创建并渲染控件，每个控件必须有id
        var objId = options.id;
        if (!objId) {
            objId = hui.Control.makeGUID(options['formname']);
            options.id = objId;
        }
        var existControl = hui.Control.getById(objId);
        if (existControl) {
            existControl.dispose();
        }

        var uiClazz = hui[type];
        if (!uiClazz) {
            hui.Control.error('Not use require(\'' + String(type).toLowerCase() + '\') or "' + String(type).toLowerCase() + '.js" is not loaded successfully.');
        }

        // 1. 模版批量生成控件时，options里一般没有m ain，m ain指向元素自身! //注:已改成默认有m ain
        // 2. new的方式创建控件时，options里一般有m ain!
        // 在这里设置m ain属性注意不能覆盖new uiClazz(options)的设置,也便于后面render时重新设置
        //if(options.m ain == undefined && m ain) {options.m ain = m ain;}//注:已移动到hui.Control.init中了

        // 设置临时parentControl放置子控件//注释掉原因:创建控件默认放在hui.window下//放到hui.Control.init中了
        //if(options.parentControl == undefined && parentControl) {options.parentControl = parentControl;}
        // 创建控件对象

        var uiObj = new uiClazz(options);
        uiObj.id = uiObj.id || objId;

        /*Hack方式不利于理解程序，所以去掉!!*/
        // 调用父类的构造函数
        //hui.Control.call( uiObj, options );
        /**
         * @name 再次调用子类的构造函数
         * @comment 这里为什么不直接放到new uiClazz(options)里呢? 因为调用父类的构造函数会被覆盖掉.
        uiClazz.call( uiObj, options );/*已废弃*
        /**/
        /*uiObj.clazz = uiClazz;// 已经使用this.constructor代替*/
        /*
        // 加到父控件的childControl中
        if (!((uiObj.parentControl && uiObj.parentControl.cc && uiObj.parentControl.cc[objId] == uiObj) &&
            (uiObj.getId && uiObj.getId() !== objId) || (uiObj.id !== objId))) {
            
            if (uiObj.parentControl && uiObj.parentControl.cc && uiObj.parentControl.cc[objId] !== uiObj) {
                hui.Control.appendControl(uiObj.parentControl, uiObj);
                //uiObj.parentControl.cc[objId] = uiObj;
            }
            else if (options.parentControl && options.parentControl.cc && options.parentControl.cc[objId] !== uiObj) {
                hui.Control.appendControl(options.parentControl, uiObj);
                //options.parentControl.cc[objId] = uiObj;
            }
        }
        */
        // 检查是否有 enterControl 方法
        if (!uiObj.enterControl) {
            var child = uiObj,
                parent = hui.Control.prototype;
            for (var key in parent) {
                if (parent.hasOwnProperty(key)) {
                    child[key] = parent[key];
                }
            }
            uiObj.enterControl();
        }


        return uiObj;
    };

    /**
     * @name 父控件添加子控件. 注: 将子控件加到父控件下面的容器中也可以调用appendSelfTo
     * @public
     * @param {Control} uiObj 子控件.
     */
    hui.Control.appendControl = function (parent, uiObj) {
        // parentControl父控件不传则默认为window对象
        // parentControl父控件默认为window对象, 不是的话后面会再改回来. 
        // var parentControl = hui.window;
        // Add: 上面这样做静态没问题，动态生成appendSelfTo就会出问题，因此需要加上options.parentControl
        // Fixme: 第二次执行到这里hui.Master.get()居然是前一个action？
        parent = parent || hui.window;
        parent.cc = parent.cc || [];

        // var ctrId = uiObj.getId ? uiObj.getId() : uiObj.id;
        // 注：从原来的父控件childControl中移除
        if (uiObj.parentControl && uiObj.parentControl.cc && uiObj.parentControl.cc != parent.cc) {
            var list = uiObj.parentControl.cc;
            for (var i = list.length - 1; i > -1; i--) {
                if (list[i] === uiObj) {
                    list.splice(i, 1);
                }
            }
        }

        // !!!悲催的案例,如果将childControl放在prototype里, 这里parent.cc===uiObj.cc!!!
        var exist = false;
        for (var i = 0, len = parent.cc.length; i < len; i++) {
            if (parent.cc[i] === uiObj) {
                exist = true;
                break;
            }
        }
        if (!exist) {
            parent.cc.push(uiObj);
        }
        // 重置parentControl标识
        uiObj.parentControl = parent;
        // !!!不能移动DOM，需自行解决，因为会打乱html布局
        /*var parentNode = parent.getMain ? parent.getMain() : null,
            main = uiObj.getMain();
        if (parentNode && main) {
            parentNode.appendChild(main);
        };*/
    };

    /**
     * @name 获取所有子节点element
     * @public
     * @param {HTMLElement} main
     * @param {String} stopAttr 如果元素存在该属性,如'ui',则不遍历其下面的子元素
     */
    hui.Control.findAllNodes = function (main, stopAttr) {
        var childNode,
            elements,
            list,
            childlist,
            node;
        elements = [];
        list = [main];

        while (list.length) {
            childNode = list.pop();
            if (!childNode) continue;
            // Not set 'stopAttr', get all nodeds.
            if (stopAttr === undefined || (childNode.getAttribute && childNode.getAttribute(stopAttr))) {
                elements.push(childNode);
            }
            childlist = childNode.childNodes;
            if (!childlist || childlist.length < 1) continue;
            if (childNode != main && stopAttr !== undefined && childNode.getAttribute(stopAttr)) {
                continue;
            }
            // 注：Nodelist是伪数组且IE不支持Array.prototype.slice.call(Nodelist)转化数组
            for (var i = 0, len = childlist.length; i < len; i++) {
                node = childlist[i];
                list.push(node);
            }
        }
        // 去掉顶层main,如不去掉处理复合控件时会导致死循环!!
        if (elements[0] === main) elements.shift();

        return elements.reverse();
    };
    /**
     * @name 获取父控件或Action下所有控件
     * @public
     * @param {Object} control
     */
    hui.Control.findAllControl = function (parentControl) {
        var childNode,
            results,
            list,
            control;
        results = [];
        if (Object.prototype.toString.call(parentControl).indexOf('Element') > -1) {
            list = hui.Control.findAllNodes(parentControl);
            for (var i = 0, len = list.length; i < len; i++) {
                if (hui.Control.isControlMain(list[i])) {
                    control = hui.Control.getById(list[i].getAttribute('ctrid'));
                    if (control) {
                        results.push(control);
                    }
                }
            }
        }
        else {
            list = [parentControl];
            while (list.length) {
                childNode = list.pop();
                if (!childNode) continue;

                results.push(childNode);

                if (!childNode.cc) continue;
                list = list.concat(childNode.cc);
            }
            // 去掉顶层父控件或Action,如不去掉处理复合控件时会导致死循环!!
            if (results.length > 0) results.shift();
            // 后序遍历出来的结果，因此需要反转数组
            results.reverse();
        }
        return results;
    };
    // 所有控件实例的索引. 注释掉原因: 建了索引会造成无法GC内存暴涨!
    // hui.Control.elemList = [];
    /**
     * @name 回溯找到当前元素所在的控件
     * @public
     * @param {Element} parentElement DOM元素
     */
    hui.Control.findByElem = function (parentElement) {
        var control = null;
        while (parentElement && parentElement.tagName) {
            //label标签自带control属性!!
            if (parentElement && hui.Control.isControlMain(parentElement)) {
                control = hui.Control.getById(parentElement.getAttribute('ctrid'));
                break;
            }
            else if (~',html,body,'.indexOf(',' + String(parentElement.tagName).toLowerCase() + ',')) {
                break;
            }
            parentElement = parentElement.parentNode;
        }
        return control;
    };

    /**
     * @name 根据控件id找到对应控件
     * @public
     * @param {Control} parentControl 可不传, 默认从当前Action开始找, 如果未使用action则直接从hui.window.childControl开始找
     * @id 控件ID
     * @param {String} 控件id
     */
    hui.Control.getById = function (id, parentControl) {
        var list,
            result = null;
        // parentControl || hui.Control.getById(parentControl) || hui.Master.get(parentControl) || hui.Master.get() || window
        if (typeof parentControl == 'string') {
            parentControl = hui.Control.getById(parentControl);
        }
        // 如果传入的parentControl是DOM元素，视为未传入值处理
        parentControl = parentControl && parentControl.getId ? parentControl :
            (hui.Action && hui.Master.get ? (hui.Master.get(parentControl) || hui.Master.get()) : hui.window);

        if (id === undefined || (parentControl && parentControl.getId && id === parentControl.getId())) {
            result = parentControl;
        }
        else if (parentControl) {
            list = hui.Control.findAllControl(parentControl);
            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i].id == id) {
                    result = list[i];
                }
            }
        }

        // If not found then find in 'window.cc'
        if (!result) {
            list = hui.Control.findAllControl(hui.window);
            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i].id == id) {
                    result = list[i];
                }
            }
        }

        return result;
    };
    /**
     * @name 根据控件formname找到对应控件
     * @static
     * @param {String} formname 控件formname
     * @param {Control} parentNode 父控件
     * @param {Boolean} all 仅查找直接子级，默认所有子级
     */
    hui.Control.getByFormnameAll = function (formname, parentNode, all) {
        var list = [],
            childNodes,
            item,
            /* 强制确认parentControl */
            parentControl = parentNode && typeof parentNode == 'object' ? parentNode : hui.window;

        if (formname) {
            formname = String(formname);

            // 注掉原因：不应该找自身！！
            // // 先查找自身 
            // childNodes = parentControl && parentControl.cc ? parentControl.cc : [];
            // //childNodes.unshift(parentControl);
            // if (parentControl.getFormname && parentControl.getFormname() === formname) {
            //     list.push(parentControl);
            // }

            // 再遍历控件树
            childNodes = parentControl && parentControl.cc ?
                (all === false ? parentControl.cc : hui.Control.findAllControl(parentControl)) : [];
            for (var i = 0, len = childNodes.length; i < len; i++) {
                item = childNodes[i];
                if ((item.getFormname && item.getFormname() === formname) || item['formname'] === formname) {
                    list.push(childNodes[i]);
                }
            }
        }

        return list;
    };
    /**
     * @name 根据控件formname找到对应控件，只返回一个结果
     * @static
     * @param {String} formname 控件formname
     * @param {Control} parentNode 父控件
     */
    hui.Control.getByFormname = function (formname, parentNode) {
        var result = null,
            list,
            min = Number.MAX_VALUE,
            deep,
            ctr;

        parentNode = parentNode && typeof parentNode === 'object' ? parentNode : hui.window;

        list = hui.Control.getByFormnameAll(formname, parentNode);
        // 注：默认返回直接子级第一个,直接子级没有才会返回最近子级的第一个
        // 注：要找到所有直接子级等于formname的可以用getByFormnameAll(formname, parentNode, false)
        for (var i = 0, len = list.length; i < len && min > 0; i++) {
            deep = 0;
            ctr = list[i];
            while (ctr.parentControl && ctr.parentControl !== parentNode) {
                deep++;
                ctr = ctr.parentControl;
            }
            if (deep < min) {
                min = deep;
                result = list[i];
            }
        }

        return result;
    };
    /**
     * @name 销毁一组控件
     * @static
     * @param {String} list 一组控件
     */
    hui.Control.disposeList = function (list) {
        if (Object.prototype.toString.call(list) === '[object Array]') {
            for (var i = 0, len = list.length; i < len; i++) {
                if (list[i] && list[i].dispose) {
                    list[i].dispose();
                }
            }
        }
    };

    /**
     * @name 为目标元素添加className
     * @public
     * @param {HTMLElement|string} element 目标元素或目标元素的id
     * @param {String} className 要添加的className，允许同时添加多个class，中间使用空白符分隔
     * @remark
     * 使用者应保证提供的className合法性，不应包含不合法字符，className合法字符参考：http://www.w3.org/TR/CSS2/syndata.html。
     * @returns {HTMLElement} 目标元素
     */
    hui.Control.hasClass = function (element, className) {
        return (~(' ' + element.className + ' ').indexOf(' ' + className + ' '));
    };
    hui.Control.addClass = function (element, className) {
        if (~'[object Array][object NodeList]'.indexOf(Object.prototype.toString.call(element))) {
            for (var i = 0, len = element.length; i < len; i++) {
                hui.Control.addClass(element[i], className);
            }
        }
        else if (element) {
            hui.Control.removeClass(element, className);
            element.className = (element.className + ' ' + className).replace(/(\s)+/ig, ' ');
        }
        return element;
    };
    // Support * and ?, like hui.Control.removeClass(elem, 'daneden-*');
    hui.Control.removeClass = function (element, className) {
        if (~'[object Array][object NodeList]'.indexOf(Object.prototype.toString.call(element))) {
            for (var i = 0, len = element.length; i < len; i++) {
                hui.Control.removeClass(element[i], className);
            }
        }
        else if (element) {
            var list = className.replace(/\s+/ig, ' ').split(' '),
                /* Attention: str need two spaces!! */
                str = (' ' + (element.className || '').replace(/(\s)/ig, '  ') + ' '),
                name,
                rex;
            // 用list[i]移除str
            for (var i = 0, len = list.length; i < len; i++) {
                name = list[i];
                name = name.replace(/(\*)/g, '\\S*').replace(/(\?)/g, '\\S?');
                rex = new RegExp(' ' + name + ' ', 'ig');
                str = str.replace(rex, ' ');
            }
            str = str.replace(/(\s)+/ig, ' ');
            str = str.replace(/^(\s)+/ig, '').replace(/(\s)+$/ig, '');
            element.className = str;
        }
        return element;
    };

    /**
     * @name JS操作CSS
     * @public
     * @param {String} <style>的id
     */
    hui.Control.hasCssString = function hasCssString(id) {
        var sheets,
            c,
            result = false;
        if (document.createStyleSheet && (sheets = document.styleSheets)) {
            for (var i = 0, len = sheets.length; i < len; i++) {
                c = sheets[i];
                if (c && c.owningElement && c.owningElement.id === id) {
                    result = c.owningElement;
                    break;
                }
                else if (c && c.ownerNode && c.ownerNode.id === id) {
                    result = c.ownerNode;
                    break;
                }
            }
        }
        else if ((sheets = document.getElementsByTagName('style'))) {
            for (var i = 0, len = sheets.length; i < len; i++) {
                c = sheets[i];
                if (c.id === id) {
                    result = c;
                    break;
                }
            }
        }

        return result;
    };
    hui.Control.removeCssString = function removeCssString(id) {
        var parent,
            result = hui.Control.hasCssString(id);
        if (result) {
            parent = result.parentNode;
            parent.removeChild(result);
        }
    };

    hui.Control.importCssString = function importCssString(cssText, id) {
        hui.Control.removeCssString(id);

        var style = document.createElement('style');
        if (id) {
            style.id = id;
        }
        var head = document.head || document.body || document.documentElement;
        head.insertBefore(style, head.lastChild);
        if (head !== document.documentElement && style.nextSibling) {
            head.insertBefore(style.nextSibling, style);
        }
        style.setAttribute('type', 'text/css');
        // all browsers, except IE before version 9
        if (style.styleSheet) {
            style.styleSheet.cssText = cssText;
        }
        // Internet Explorer before version 9
        else {
            style.appendChild(document.createTextNode(cssText));
        }

        return style;
    };

    hui.Control.format = function (source, opts) {
        function handler(match, key) {
            var type = String(key).indexOf('!!') === 0 ? 'decode' : String(key).indexOf('!') === 0 ? '' : 'encode',
                parts = key.replace(/^!!?/, '').split('.'),
                part = parts.shift(),
                cur = data,
                variable;
            while (part) {
                if (cur[part] !== undefined) {
                    cur = cur[part];
                }
                else {
                    cur = undefined;
                    break;
                }
                part = parts.shift();
            }

            variable = cur;
            if ('[object Function]' === toString.call(variable)) {
                variable = variable(key);
            }
            if (undefined !== variable) {
                variable = String(variable);
                // encodeURIComponent not encode '
                var fr = '&|<|>| |\'|"|\\'.split('|'),
                    to = '&amp;|&lt;|&gt;|&nbsp;|&apos;|&quot;|&#92;'.split('|');
                if (type === 'decode') {
                    for (var i = fr.length - 1; i > -1; i--) {
                        variable = variable.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
                    }
                }
                else if (type === 'encode') {
                    for (var i = 0, l = fr.length; i < l; i++) {
                        variable = variable.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
                    }
                }
            }

            return (undefined === variable ? '' : variable);
        }

        source = String(source);
        var data = Array.prototype.slice.call(arguments, 1),
            toString = Object.prototype.toString;
        if (data.length) {
            data = (data.length == 1 ?
                /* ie 下 Object.prototype.toString.call(null) == '[object Object]' */
                (opts !== null && (/\[object (Array|Object)\]/.test(toString.call(opts))) ? opts : data) : data);

            return source.replace(/#\{(.+?)\}/g, handler).replace(/\{\{([^\{]+?)\}\}/g, handler);
        }
        return source;
    };

    hui.Control.formatDate = function (date, fmt) {
        if (!date) date = new Date();
        fmt = fmt || 'yyyy-MM-dd HH:mm';
        var o = {
            'M+': date.getMonth() + 1, //月份      
            'd+': date.getDate(), //日      
            'h+': date.getHours() % 12 === 0 ? 12 : date.getHours() % 12, //小时      
            'H+': date.getHours(), //小时      
            'm+': date.getMinutes(), //分      
            's+': date.getSeconds(), //秒      
            'q+': Math.floor((date.getMonth() + 3) / 3), //季度      
            'S': date.getMilliseconds() //毫秒      
        };
        var week = {
            '0': '/u65e5',
            '1': '/u4e00',
            '2': '/u4e8c',
            '3': '/u4e09',
            '4': '/u56db',
            '5': '/u4e94',
            '6': '/u516d'
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? '/u661f/u671f' : '/u5468') : '') + week[date.getDay() + '']);
        }
        for (var k in o) {
            if (o.hasOwnProperty(k) && new RegExp('(' + k + ')').test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
            }
        }
        return fmt;
    };
    /*  
  将String类型解析为Date类型.  
  parseDate('2006-1-1') return new Date(2006,0,1)  
  parseDate(' 2006-1-1 ') return new Date(2006,0,1)  
  parseDate('2006-1-1 15:14:16') return new Date(2006,0,1,15,14,16)  
  parseDate(' 2006-1-1 15:14:16 ') return new Date(2006,0,1,15,14,16);  
  parseDate('不正确的格式') retrun null  
*/
    hui.Control.parseDate = function (str) {
        str = String(str).replace(/^[\s\xa0]+|[\s\xa0]+$/ig, '');
        var results = null;

        //秒数 #9744242680 
        results = str.match(/^ *(\d{10}) *$/);
        if (results && results.length > 0)
            return new Date(parseInt(str) * 1000);

        //毫秒数 #9744242682765 
        results = str.match(/^ *(\d{13}) *$/);
        if (results && results.length > 0)
            return new Date(parseInt(str));

        //20110608 
        results = str.match(/^ *(\d{4})(\d{2})(\d{2}) *$/);
        if (results && results.length > 3)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]));

        //20110608 1010 
        results = str.match(/^ *(\d{4})(\d{2})(\d{2}) +(\d{2})(\d{2}) *$/);
        if (results && results.length > 5)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]));

        //2011-06-08 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) *$/);
        if (results && results.length > 3)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]));

        //2011-06-08 10:10 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) +(\d{1,2}):(\d{1,2}) *$/);
        if (results && results.length > 5)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]));

        //2011/06\\08 10:10:10 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) +(\d{1,2}):(\d{1,2}):(\d{1,2}) *$/);
        if (results && results.length > 6)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]), parseInt(results[6]));

        return (new Date(str));
    };

    /**
     * 对特殊字符和换行符编码// .replace(/%/ig,"%-")
     */
    hui.Control.encode = function (str, decode) {
        str = String(str);
        // encodeURIComponent not encode '
        var fr = '%| |&|;|=|+|<|>|,|"|\'|#|/|\\|\n|\r|\t'.split('|'),
            to = '%25|%20|%26|%3B|%3D|%2B|%3C|%3E|%2C|%22|%27|%23|%2F|%5C|%0A|%0D|%09'.split('|');
        if (decode == 'decode') {
            for (var i = fr.length - 1; i > -1; i--) {
                str = str.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
            }
        }
        else {
            for (var i = 0, l = fr.length; i < l; i++) {
                str = str.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
            }
        }
        return str;
    };
    hui.Control.decode = function (str) {
        return this.encode(str, 'decode');
    };
    hui.Control.encodehtml = function (str, decode) {
        str = String(str);
        // encodeURIComponent not encode '
        var fr = '&|<|>| |\'|"|\\'.split('|'),
            to = '&amp;|&lt;|&gt;|&nbsp;|&apos;|&quot;|&#92;'.split('|');
        if (decode == 'decode') {
            for (var i = fr.length - 1; i > -1; i--) {
                str = str.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
            }
        }
        else {
            for (var i = 0, l = fr.length; i < l; i++) {
                str = str.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
            }
        }
        return str;
    };
    hui.Control.decodehtml = function (str) {
        return this.encodehtml(str, 'decode');
    };


    //setInnerHTML: function (elem, html){}
    hui.Control.setInnerHTML = function (elem, html) {
        elem = elem && elem.getMain ? elem.getMain() : elem;
        if (elem && elem.innerHTML !== undefined) {
            elem.innerHTML = html;
        }
        return elem;
    };
    hui.Control.setInnerText = function (elem, text) {
        if (!elem) return;
        if (elem.textContent !== undefined) {
            elem.textContent = text;
        }
        else {
            elem.innerText = text;
        }
    };

    hui.Control.error = function (str) {
        if (hui.window && hui.window.console && hui.window.console.error) {
            hui.window.console.error(str);
        }
    };
    hui.Control.log = function (str) {
        if (hui.window && hui.window.console && hui.window.console.log) {
            hui.window.console.log(str);
        }
    };
    hui.Control.getExtClass = function (clazz) {
        var result = function () {};
        switch (clazz) {
        case 'hui.BaseModel':
            if (typeof hui !== 'undefined' && hui.BaseModel) {
                result = hui.BaseModel;
            }
            else {
                result.get = new Function();
                result.set = new Function();
            }
            break;
        case 'hui.Template':
            if (typeof hui !== 'undefined' && hui && hui.Template) {
                result = hui.Template;
            }
            else {
                result.getTarget = new Function();
                result.merge = new Function();
            }
            break;
        case 'hui.Validator':
            if (typeof hui !== 'undefined' && hui.Validator) {
                result = hui.Validator;
            }
            else {
                result.cancelNotice = new Function();
                result.set = new Function();
            }
            break;
        case 'hui.Action':
            if (typeof hui !== 'undefined' && hui.Validator) {
                result = hui.Validator;
            }
            else {
                result.get = new Function();
            }
            break;
        case 'hui.context':
            if (typeof hui !== 'undefined' && hui.context) {
                result = hui.context;
            }
            else {
                result = {};
                result.get = new Function();
            }
            break;
        default:
        }
        return result;
    };
});
'::hui_requester::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   

/**
 * @name Requester请求管理类
 * @public
 * @author haiyang5210
 * @date 2015-06-25 19:01
 */
hui.define('hui_requester', [], function () {

    var Requester = {
        /**
         * @name 全局事件处理接口 注：不支持onsuccess
         * @public
         */
        handler: {},
        /** 
         * @name 预置XMLHttpRequestProxy对象
         * @private
         * @return {XMLHttpRequestProxy} XMLHttpRequestProxy对象
         * @description
         */
        createXHRProxyObject: function () {
            var me = this,
                xhr = {};
            xhr.xhr = window.XMLHttpRequest ? new window.XMLHttpRequest() : new window.ActiveXObject('Microsoft.XMLHTTP');
            xhr.eventHandlers = {};
            xhr.fire = me.creatFireHandler();
            // 标示是否是本地调试
            xhr.online = (/^https?:$/i.test(window.location.protocol));
            // 处理成功返回结果
            xhr.responseCallback = function (handler, data) {
                // 根据返回结果更新用户状态
                window.Requester.updateStatus(data);

                // 当后端验证失败时
                if (data && window.Requester.backendError) {
                    window.Requester.backendError(xhr, data);
                    //return 'finished';
                }

                data = data || [];
                // Todo: 如果返回用户状态表示此次请求非法，该如何处理？// Fixed: 此类情况应该服务器端判断之后再返回一个错误提示结果。
                handler && window.setTimeout(function () {
                    handler(data);
                }, 0);
            };

            return xhr;
        },
        /** 
         * @name 生成新的触发事件方法
         * @private
         * @param {String} type 事件类型
         */
        creatFireHandler: function () {
            return function (type) {
                type = 'on' + type;
                var xhr = this,
                    handler = xhr.eventHandlers[type],
                    globelHandler = window.Requester.handler[type],
                    data;
                /**
                 * 注：在这里使用了setTimeout来断开xhr的链式作用域，如果不使用setTimeout
                 * 会发现在连接池开启的情况下
                 * window.Requester.get('tpl.html', { onsuccess: function() { window.Requester.get('tpl.html', { onsuccess: function(){alert(1)} }); } });
                 * 永远不会执行alert(1);单步跟进会发现xhr的readyState到3就停住了。
                 */
                // 不对事件类型进行验证 
                if (handler) {
                    // 如果action已被销毁则直接忽略本次请求结果.因此无需销毁xhr的fire方法!
                    if (xhr.eventHandlers.action && !xhr.eventHandlers.action.active) {
                        return;
                    }

                    if (xhr.tick) {
                        clearTimeout(xhr.tick);
                    }

                    if (type != 'onsuccess') {
                        window.setTimeout(function () {
                            handler('failure', xhr);
                        }, 0);
                    }
                    else {
                        if (xhr.eventHandlers['datatype'] == 'XML') {
                            try {
                                xhr.xhr.responseXML;
                                xhr.responseCallback(handler, xhr.xhr.responseXML);
                            }
                            catch (error) {
                                window.setTimeout(function () {
                                    handler('error', xhr);
                                }, 0);
                                return;
                            }
                        }
                        else if (xhr.eventHandlers['datatype'] == 'TEXT') {
                            try {
                                xhr.xhr.responseText;
                                xhr.responseCallback(handler, xhr.xhr.responseText);
                            }
                            catch (error) {
                                window.setTimeout(function () {
                                    handler('error', xhr);
                                }, 0);
                                return;
                            }
                        }
                        else { //if (xhr.eventHandlers['datatype'] == 'JSON')
                            // 处理获取xhr.responseText导致出错的情况,比如请求图片地址. 
                            try {
                                xhr.xhr.responseText;
                            }
                            catch (error) {
                                window.setTimeout(function () {
                                    handler('error', xhr);
                                }, 0);
                                return;
                            }

                            var text = xhr.xhr.responseText.replace(/^\s+/ig, '');
                            if (text.indexOf('[') === 0 || text.indexOf('{') === 0) {
                                // {success:true,message: 
                                // 插入表单验证错误提示 
                                var JSON_Parser;
                                try {
                                    JSON_Parser = new Function('return ' + text + ';');
                                    data = JSON_Parser();
                                }
                                // 如果json解析出错则尝试移除多于逗号再试 
                                catch (e) {
                                    throw new Error('JSON parse error.');
                                }
                                xhr.responseCallback(handler, data);
                            }
                            else {
                                window.setTimeout(function () {
                                    handler(null, text);
                                }, 0);
                            }
                        }

                    }
                }
                // 检查是否配置了全局事件
                else if (globelHandler) {
                    // onsuccess不支持全局事件 
                    if (type == 'onsuccess') {
                        return;
                    }
                    globelHandler(xhr);
                }
            };
        },
        /**
         * @name 检测是否有空闲的XHR或创建新对象
         * @private
         * @after window.Requester
         * @comment 使用Facade外观模式修改window.Requester.request方法
         * 以增加路径权限判断
         */
        getValidXHR: function () {
            var me = this;
            return me.createXHRProxyObject();
        },
        /**
         * @name request发送请求
         * @private
         * @url {String} 请求的URL
         * @options {Map} POST的参数，回调函数，MD5加密等
         */
        request: function (url, opt_options, xhr) {
            xhr = xhr || this.getValidXHR();
            // 权限检测
            var result = this.beforeRequest(url, opt_options);


            // Mockup 返回是JSON数据, 注：Mockup 默认都是成功的，因此无需xhr.fire('success');
            if (result && typeof result != 'string' && xhr) {
                xhr.responseCallback(opt_options['onsuccess'], result);
            }
            // 有可用连接且url是字符串
            else if (result && typeof result == 'string' && xhr) {
                url = result;
                var me = this,
                    options = opt_options || {},
                    data = options.data || '',
                    async = xhr.online && options.async !== false,
                    username = options.username || '',
                    password = options.password || '',
                    method = (options.method || 'GET').toUpperCase(),
                    headers = options.headers || {},

                    timeout = options.timeout || 0,
                    str,
                    stateChangeHandler;



                xhr.eventHandlers['on404'] = me.on404;
                xhr.eventHandlers['onsuccess'] = me.onsuccess;
                xhr.eventHandlers['ontimeout'] = me.ontimeout;
                if (!options.onfailure) {
                    xhr.eventHandlers['onfailure'] = window.Requester.fn(me.onfailure, xhr);
                }
                // 将options参数中的事件参数复制到eventHandlers对象中 
                // 这里复制所有options的成员，eventHandlers有冗余 
                // 但是不会产生任何影响，并且代码紧凑
                for (var key in options) {
                    if (options.hasOwnProperty(key)) {
                        xhr.eventHandlers[key] = options[key];
                    }
                }
                xhr.url = url;

                headers['X-Requested-With'] = 'XMLHttpRequest';
                headers['Content-Type'] = xhr.eventHandlers['contentType'] || xhr.eventHandlers['Content-Type'] || 'application/x-www-form-urlencoded';
                headers['Accept'] = xhr.eventHandlers['accept'] || xhr.eventHandlers['Accept'] || 'application/x-www-form-urlencoded';
                headers['dataType'] = xhr.eventHandlers['dataType'] = xhr.eventHandlers['datatype'] = (options.dataType || 'JSON').toLowerCase();

                try {
                    var querystring = '';
                    // 注：每次请求必须带上的公共参数,如token
                    var param = {};
                    for (var i = 0, len = Requester.sysParam.length; i < len; i++) {
                        Requester.sysParam[i](param);
                    }

                    for (var key in param) {
                        querystring = querystring + '&' + window.Requester.encode(key) + '=' + window.Requester.encode(param[key]);
                    }

                    // 提交到服务器端的参数是Map则转换为string
                    if (Object.prototype.toString.call(data) === '[object Object]') {
                        str = [];
                        for (var key in data) {
                            if (key && data.hasOwnProperty(key)) {
                                str.push(window.Requester.encode(key) + '=' + window.Requester.encode(data[key]));
                            }
                        }
                        querystring = querystring + '&' + str.join('&');
                    }
                    else {
                        // user_list?& Nginx will down!!
                        querystring = querystring + (data ? '&' + data : '');
                    }

                    // 使用GET方式提交
                    if (method == 'GET') {
                        if (querystring) {
                            url += (url.indexOf('?') >= 0 ? (querystring.substr(0, 1) == '&' ? '' : '&') : '?') + querystring;
                            querystring = null;
                        }
                    }

                    try {
                        if (username) {
                            xhr.xhr.open(method, url, async, username, password);
                        }
                        else {
                            xhr.xhr.open(method, url, async);
                        }
                    }
                    catch (e) {
                        //debugger;
                        //alert(e.message ? e.message : String(e));
                    }


                    stateChangeHandler = window.Requester.fn(me.createStateChangeHandler, xhr);
                    if (async) {
                        xhr.xhr.onreadystatechange = stateChangeHandler;
                    }

                    // 在open之后再进行http请求头设定 
                    // FIXME 是否需要添加; charset=UTF-8呢 

                    for (var key in headers) {
                        if (headers.hasOwnProperty(key)) {
                            xhr.xhr.setRequestHeader(key, headers[key]);
                        }
                    }

                    xhr.fire('beforerequest');

                    if (timeout) {
                        xhr.tick = setTimeout(function () {
                            xhr.xhr.onreadystatechange = window.Requester.blank;
                            xhr.xhr.abort();
                            delete xhr.xhr;
                            xhr.fire('timeout');
                        }, timeout);
                    }
                    xhr.xhr.send(querystring);

                    if (!async) {
                        stateChangeHandler.call(xhr);
                    }
                }
                catch (ex) {
                    xhr.fire('failure');
                }
            }

        },
        /** 
         * @name readyState发生变更时调用
         * @private
         * @ignore
         */
        createStateChangeHandler: function () {
            var xhr = this,
                stat; // window.console.log(xhr.readyState);
            if (xhr.xhr.readyState == 4) {
                try {
                    stat = xhr.xhr.status;
                }
                catch (ex) {
                    // 在请求时，如果网络中断，Firefox会无法取得status 
                    xhr.fire('failure');
                    return;
                }

                xhr.fire(stat);

                // http://www.never-online.net/blog/question.asp?id=261 
                // case 12002: // Server timeout 
                // case 12029: // dropped connections 
                // case 12030: // dropped connections 
                // case 12031: // dropped connections 
                // case 12152: // closed by server 
                // case 13030: // status and statusText are unavailable 

                // IE error sometimes returns 1223 when it
                // should be 204, so treat it as success 
                if ((stat >= 200 && stat < 300) || stat == 304 || stat == 1223) {
                    // 注：在Chrome下，Request.post(url, {onsuccess: function(){Request.post(url, {onsuccess: function(){alert()}})}}) 
                    // 如上，两次请求会共用同一个XHR对象从而造成status=0的错误，因此需要标识请求是否已成功返回
                    xhr.status = 'finished';
                    xhr.fire('success');
                }
                else {
                    if (stat === 0 && !xhr.online) {
                        xhr.fire('success');
                    }
                    else {
                        if (stat === 0 && window.console && window.console.error) {
                            window.console.error('XHR Error: Cross domain, cannot access: %s.', xhr.url);
                        }
                        xhr.fire('failure');
                    }
                }

                /* 
             * NOTE: Testing discovered that for some bizarre reason, on Mozilla, the 
             * JavaScript <code>XmlHttpRequest.onreadystatechange</code> handler 
             * function maybe still be called after it is deleted. The theory is that the 
             * callback is cached somewhere. Setting it to null or an empty function does 
             * seem to work properly, though. 
             *
             * On IE, there are two problems: Setting onreadystatechange to null (as 
             * opposed to an empty function) sometimes throws an exception. With 
             * particular (rare) versions of jscript.dll, setting onreadystatechange from 
             * within onreadystatechange causes a crash. Setting it from within a timeout 
             * fixes this bug (see issue 1610). 
             *
             * End result: *always* set onreadystatechange to an empty function (never to 
             * null). Never set onreadystatechange from within onreadystatechange (always 
             * in a setTimeout()). 
             *
            window.setTimeout(function() { 
                // 避免内存泄露. 
                // 由new Function改成不含此作用域链的 window.Requester.blank 函数, 
                // 以避免作用域链带来的隐性循环引用导致的IE下内存泄露. By rocy 2011-01-05 . 
                xhr.onreadystatechange = window.Requester.blank; 
                if (xhr.eventHandlers['async']) { 
                    xhr = null; 
                } 
            }, 0); */

                if (window.Requester.checkQue) {
                    window.setTimeout(window.Requester.checkQue, 0);
                }
            }
        },
        /**
         * 对特殊字符和换行符编码// .replace(/%/ig,"%-")
         */
        encode: function (str, decode) {
            str = String(str);
            // encodeURIComponent not encode '
            var fr = '%| |&|;|=|+|<|>|,|"|\'|#|/|\\|\n|\r|\t'.split('|'),
                to = '%25|%20|%26|%3B|%3D|%2B|%3C|%3E|%2C|%22|%27|%23|%2F|%5C|%0A|%0D|%09'.split('|');
            if (decode == 'decode') {
                for (var i = fr.length - 1; i > -1; i--) {
                    str = str.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
                }
            }
            else {
                for (var i = 0, l = fr.length; i < l; i++) {
                    str = str.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
                }
            }
            return str;
        },
        decode: function (str) {
            return this.encode(str, 'decode');
        },

        /**
         * @name 处理404错误
         */
        on404: function () {},
        onsuccess: function () {},
        ontimeout: function () {},
        onfailure: function () {
            var me = this;
            if (hui && hui.Pnotice && hui.Pnotice.show) {
                hui.Pnotice.show('Error: url "' + me.url + '" response ' + me.xhr.status, 3000);
            }
            me.fire('success');
        }
    };
    /**
     * 不含任何作用域的空函数
     */
    Requester.blank = function () {};

    /**
     * @name 增加每次请求必须带上的公共参数,如token
     * @public
     * @param {String} str 已有参数
     */
    Requester.sysParam = [];
    Requester.addSysParam = function (func) {
        Requester.sysParam.push(func);
    };

    /** 
     * @name 为对象绑定方法和作用域
     * @private
     * @param {Function|String} handler 要绑定的函数，或者一个在作用域下可用的函数名
     * @param {Object} obj 执行运行时this，如果不传入则运行时this为函数本身
     * @param {args* 0..n} args 函数执行时附加到执行时函数前面的参数
     * @returns {Function} 封装后的函数
     */
    Requester.fn = function (func, scope) {
        if (Object.prototype.toString.call(func) === '[object String]') {
            func = scope[func];
        }
        if (Object.prototype.toString.call(func) !== '[object Function]') {
            throw 'Error "Requester.fn()": "func" is null';
        }
        var xargs = arguments.length > 2 ? [].slice.call(arguments, 2) : null;
        return function () {
            var fn = '[object String]' == Object.prototype.toString.call(func) ? scope[func] : func,
                args = (xargs) ? xargs.concat([].slice.call(arguments, 0)) : arguments;
            return fn.apply(scope || fn, args);
        };
    };
    Requester.formatDate = function (date, fmt) {
        if (!date) date = new Date();
        fmt = fmt || 'yyyy-MM-dd HH:mm';
        var o = {
            'M+': date.getMonth() + 1, //月份      
            'd+': date.getDate(), //日      
            'h+': date.getHours() % 12 === 0 ? 12 : date.getHours() % 12, //小时      
            'H+': date.getHours(), //小时      
            'm+': date.getMinutes(), //分      
            's+': date.getSeconds(), //秒      
            'q+': Math.floor((date.getMonth() + 3) / 3), //季度      
            'S': date.getMilliseconds() //毫秒      
        };
        var week = {
            '0': '/u65e5',
            '1': '/u4e00',
            '2': '/u4e8c',
            '3': '/u4e09',
            '4': '/u56db',
            '5': '/u4e94',
            '6': '/u516d'
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? '/u661f/u671f' : '/u5468') : '') + week[date.getDay() + '']);
        }
        for (var k in o) {
            if (o.hasOwnProperty(k) && new RegExp('(' + k + ')').test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
            }
        }
        return fmt;
    };

    /**
     * @name 发送Requester请求
     * @public
     * @function
     * @grammar Requester.get(url, params)
     * @param {String}     url         发送请求的url地址
     * @param {String}     data         发送的数据
     * @param {Function} [onsuccess] 请求成功之后的回调函数，function(XMLHttpRequest xhr, string responseText)
     * @meta standard
     * @see Requester.request
     * @returns {XMLHttpRequest}     发送请求的XMLHttpRequest对象
     */
    // 'onsuccess': onsuccess,'method': 'POST','data': data,'action': action,'async': async,'usemd5': true
    Requester.get = function (url, params) {
        params.method = 'GET';
        return Requester.request(url, params);
    };
    Requester.head = function (url, params) {
        params.method = 'HEAD';
        return Requester.request(url, params);
    };
    Requester.post = function (url, params) {
        params.method = 'POST';
        return Requester.request(url, params);
    };
    Requester.postMD5 = function (url, params) {
        params.method = 'POST';
        params.usemd5 = true;
        return Requester.request(url, params);
    };
    Requester.put = function (url, params) {
        params.method = 'PUT';
        return Requester.request(url, params);
    };
    Requester['delete'] = function (url, params) {
        params.method = 'DELETE';
        return Requester.request(url, params);
    };

    /*============================================
 * 客户端模拟请求返回结果
 ============================================*/
    /**
     * @name 增加Mockup拦截器
     * @private
     * @return {null|String} null或新url
     */
    Requester.beforeRequest = function (url, opt_options) {
        // 检查请求的资源是否有权限
        var permit,
            Permission = Requester.getExtClass('hui.Permission'),
            Mockup = Requester.getExtClass('hui.Mockup');

        permit = Permission.checkRequest(url, opt_options);
        if (permit && permit[0] == 'notpermit') {
            return null;
        }
        else {
            url = permit ? permit[1] : url;
        }

        var result = url;
        // 检查是否启用了mockup
        if (!Mockup.stop && Mockup.find(url)) {
            if (window.console && window.console.log) {
                window.console.log(url);
            }
            result = hui.Mockup.get(url, opt_options);
        }

        return result;
    };

    /**
     * @name 根据返回结果更新用户状态
     * @private
     */
    Requester.updateStatus = function (data) {
        // 更新用户状态, 注: 每次请求都会返回用户状态 // Todo: 如果有需要用户再次发出请求以确认用户状态的呢？// Fixed: 应该服务器端负责处理
        if (window.hui && hui.Permission && hui.Permission.updateStatus) {
            // hui.Permission.updateStatus(data); 
        }
    };

    /*============================================
 * 请求返回自动校验
 ============================================*/
    /**
     * @name 当后端验证失败时自动调用
     * @private
     * @data {Map} XHR返回的responseText
     * @return {void}
     */
    Requester.backendError = function (xhr, data) {
        var action;
        // 注：hui.Action.started标识框架是否已启动
        if (window.hui && hui.Action && hui.Action.started && hui.Master.get) {
            action = hui.Master.get();
            if (action && action.showErrorByTree) {
                action.showErrorByTree(data);
                return 'finished';
            }
        }
    };

    /**============================================
     * @name 发送JSONP请求
     * @public
     * @param {String} url 请求的地址
     * @param {String|Object} data 发送的参数
     * @param {String} onsuccess 回调函数
     * @param {String|Object} action 发送请求的Action
     **============================================*/

    /** 
     * JSONP回调接口MAP
     */
    Requester.jsonproxy = {};
    /**
     * @name 发送JSONP请求
     * @public
     */
    Requester.JSONP = function (url, params) {
        var Mockup = Requester.getExtClass('hui.Mockup'),
            params = params || {};
        // 检查是否启用了mockup
        if (!Mockup.stop && Mockup.find(url)) {
            if (window.console && window.console.log) {
                window.console.log(url);
            }
            if (Object.prototype.toString.call(params.callback) === '[object Function]') {
                return params.callback(Mockup.get(url));
            }
            else if (Object.prototype.toString.call(params.callback) === '[object String]') {
                var callback = Function('return ' + params.callback)();
                if (Object.prototype.toString.call(callback) === '[object Function]') {
                    return callback(Mockup.get(url));
                }
            }
        }

        var me = this,
            // 获取可用JSONP对象, 不存在则自动生成
            proxy = me.getValidProxy(params['action']);

        proxy['action'] = params['action'];
        proxy['callback'] = params['callback'];
        proxy['status'] = 'send';

        var args = [];
        if (params['data']) {
            for (var i in params['data']) {
                if (params['data'].hasOwnProperty(i)) {
                    args.push(Requester.encode(i) + '=' + Requester.encode(params['data'][i]));
                }
            }
        }
        !params.norand && args.push('rand=' + Math.random());
        params.callback && args.push(Object.prototype.toString.call(params.callback) === '[object String]' ? 'callback=' + params.callback : 'callback=window.Requester.jsonproxy_callback("' + proxy['id'] + '").callback');

        document.getElementById(proxy['id']).src = url + (!args.length ? '' : (~url.indexOf('?') ? '&' : '?')) + args.join('&');
    };
    Requester.jsonproxy_callback = function (id) {
        return window.Requester.jsonproxy[id];
    };
    /**
     * @name 返回可用JSONP对象
     * @private
     * @return {Object}
     */
    Requester.getValidProxy = function () {
        var me = this;
        return me.createProxy();
    };
    /**
     * @name 工厂模式创建JSONP对象
     * @private
     * @param {id String} 唯一标识
     * @return {void}
     */
    Requester.createProxy = function (id) {
        // this->window.Requester
        var me = this,
            proxy = {};

        proxy.id = id || Requester.formatDate(new Date(), 'yyyyMMddHHmmss') + '' + String(Math.random()).substr(3, 4);
        proxy.status = 'finished';
        proxy.callback = me.creatProxyCallback();

        var script = document.createElement('script');
        script.id = proxy.id;
        script.type = 'text/javascript';
        script.charset = 'utf-8';
        document.getElementsByTagName('head')[0].appendChild(script);
        script = null;

        window.Requester.jsonproxy[proxy.id] = proxy;

        return proxy;
    };
    /**
     * @name 工厂模式创建JSONP对象回调接口
     * @private
     * @return {void}
     */
    Requester.creatProxyCallback = function () {
        return function (data) {
            // this->JSONP Object
            var proxy = this;
            proxy.status = 'finished';

            // 当后端验证失败时, 调用系统验证接口
            if (proxy.action && data && window.Requester && window.Requester.backendError) {
                window.Requester.backendError(proxy, data);
                //return 'finished';
            }

            // 调用用户传入的回调接口
            if (Object.prototype.toString.call(proxy.callback) === '[object Function]') {
                proxy.callback(data);
            }
        };
    };

    /*============================================
 * Requester扩展模块 - JSONP请求池
 ============================================*/
    /**
     * @name 返回可用JSONP对象
     * @private
     * @return {String} id 唯一标识
     */
    Requester.getValidProxy = function () {
        var me = this,
            i,
            proxy = null,
            script;

        // 查找可用JSONP对象
        for (i in me.jsonproxy) {
            if (i && me.jsonproxy.hasOwnProperty(i) && me.jsonproxy[i] && me.jsonproxy[i].status == 'finished') {
                script = document.getElementById(i);
                if (script && window.addEventListener) {
                    script.parentNode.removeChild(script);
                    proxy = me.createProxy(i);
                }
                break;
            }
        }

        return (proxy || me.createProxy());
    };

    /**
* @name 测试代码
*
function doit() {
    // 注: test.json -> [null,[]]
    Requester.get('ajax/test.json', {
        data: '',
        onsuccess: function(data){
            alert(data)
        }
    });

    // 注: 跨域会导致请求出错
    Requester.get('http://www.5imemo.com/other/ajax/jsonp.php', {onsuccess: function(data){alert(data.success)}});

    // 注: JSONP跨域不会导致出错
    Requester.JSONP('http://www.5imemo.com/other/ajax/jsonp.php', {callback: function(data){ alert(data.id)}});
}
*/

    Requester.getExtClass = function (clazz) {
        var result = function () {};
        switch (clazz) {
        case 'hui.Permission':
            if (typeof hui !== 'undefined' && hui.Permission) {
                result = hui.Permission;
            }
            else {
                result.checkRequest = new Function();
                result.set = new Function();
            }
            break;
        case 'hui.Mockup':
            if (typeof hui !== 'undefined' && hui.Mockup) {
                result = hui.Mockup;
            }
            else {
                result.find = new Function();
                result.get = new Function();
            }
            break;
        default:
        }
        return result;
    };

    /**
     * @name 前端构造测试数据
     */
    hui.Mockup = {
        getIndex: (function () {
            var guid = 0;
            return function () {
                return guid++;
            };
        })(),
        find: function (url) {
            var target;
            var list = hui.Mockup.rules;
            //匹配所有符合表达式的路径[正则表达式]
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                if (list[i] && list[i].rule instanceof RegExp && list[i].rule.test(url)) {
                    target = list[i].target;
                }
            }
            //[优先]匹配单独具体路径
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                if (list[i] && !(list[i].rule instanceof RegExp) && list[i].rule === url) {
                    target = list[i].target;
                }
            }

            if (url && target === undefined) {
                var str = url.split('#')[0].split('?')[0];
                if (str !== url) {
                    target = hui.Mockup.find(str);
                }
            }

            return target;
        },
        get: function (url, opt_options) {
            var result = null,
                target = hui.Mockup.find(url);

            //mockup是函数
            if (Object.prototype.toString.call(target) === '[object Function]') {
                result = target(url, opt_options);
            }
            //mockup是数组
            else if (Object.prototype.toString.call(target) === '[object Array]') {
                if (Object.prototype.toString.call(target[0]) === '[object Array]') {
                    result = target[(new Date()).getTime() % target.length];
                }
                else {
                    result = target;
                }
            }
            //mockup是对象
            else if (Object.prototype.toString.call(target) === '[object Object]') {
                result = target;
            }
            //mockup不是字符串
            else if (typeof target != 'string') {
                result = target;
            }
            //mockup是字符串(url)的话直接返回
            else {
                result = target;
            }

            return result;
        },
        setRule: function (url, target) {
            hui.Mockup.remove(url, target);
            var mock = {
                rule: url,
                'target': target,
                index: hui.Mockup.getIndex()
            };
            hui.Mockup.rules.push(mock);
            return mock;
        },
        remove: function (opt) {
            var list = hui.Mockup.rules;
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                if (!list[i] ||
                    (opt.url && String(list[i].rule) !== String(opt.url)) ||
                    (opt.index && String(list[i].index) !== String(opt.index)) ||
                    (!opt.url && !opt.index)) {
                    continue;
                }
                list[i] = null;
            }
        },
        clear: function (url) {
            hui.Mockup.rules = [];
        }
    };
    hui.Mockup.rules = [];

    hui.Mockup.setRule('/helloworld', {
        status: 0,
        message: '',
        data: 'Hello world.'
    });

    // !!! global.hui = ...
    if (typeof window != 'undefined') {
        window.Requester = Requester;
    }

});
'::hui_template::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   

/**
 * @name Template模板管理类
 * @public
 * @author wanghaiyang
 * @date 2014/05/05
 */
hui.define('hui_template', [], function () {
    hui.Template = {
        /**
         * @name 解析前 originTargetContainer, 解析后 parsedTargetContainer
         */
        originTargetContainer: {},
        parsedTargetContainer: {},
        targetRule: /<!--\s*target:\s*([a-zA-Z0-9\.\-_]+)\s*-->/g,
        importRule: /<!--\s*import:\s*([a-zA-Z0-9\.\-_]+)\s*-->/g,
        /**
         * @name 解析模板字符串流[增加target]
         * @public
         * @param {String} tplStr 模板字符串流tpl:<!-- target:mergeTest -->hello {{myName}}!
         * @param {Object|string...} opts 提供相应数据的对象或多个字符串
         * @returns {String} 格式化后的字符串
         */
        parseTemplate: function (tplStr, lazyParse) {
            var me = this,
                k,
                targetNameList,
                targetContentList,
                targetList,
                sep;

            //基本思路: 使用正则提取targetName与targetContent分别放入两个数组
            tplStr = !tplStr ? '' : String(tplStr);

            //坑爹的String.split(RegExp)有兼容性问题!!!
            //找到一个不重复的字符串做分隔符
            sep = String(Math.random()).replace('.', '');
            for (var i = 0; tplStr.indexOf(sep) > -1 && i < 1000; i++) {
                sep = String(Math.random()).replace('.', '');
            }
            if (tplStr.indexOf(sep) > -1) {
                throw new Error({
                    title: 'HUI Template Error: ',
                    name: 'Math.random()'
                });
            }

            targetList = {};
            targetNameList = tplStr.match(me.targetRule) || [];
            targetContentList = tplStr.replace(me.targetRule, sep).split(sep);

            //抛弃掉第一个<!-- target: XXX -->之前的内容
            if (targetContentList.length - targetNameList.length == 1) {
                targetContentList.shift();
            }
            if (targetContentList.length != targetNameList.length) {
                throw new Error({
                    title: 'HUI Template Error: ',
                    name: 'Methond "parseTemplate()" error.'
                });
            }

            for (var i = 0, len = targetNameList.length; i < len; i++) {
                k = targetNameList[i].replace(me.targetRule, '$1');
                targetList[k] = targetContentList[i];

                //存入全局target容器(parsedTargetContainer中的后面将会替换)
                me.originTargetContainer[k] = targetContentList[i];
            }

            if (lazyParse !== true) {
                me.parseAllTarget();
            }

            return targetList;
        },
        /**
         * @name 获取Target
         * @public
         * @param {String} targetName Target名字
         * @returns {String} 未解析的target
         */
        getTarget: function (targetName) {
            var me = this;
            if (targetName === null || targetName === '') return '';

            if (me.parsedTargetContainer[targetName] === undefined) {
                throw new Error('Target "' + targetName + '" not exist.');
            }

            return me.parsedTargetContainer[targetName];
        },
        /**
         * @name 依赖于me.originTargetContainer循环解析targetList中的target
         * @public
         * @param {String} tplStr 模板字符串流tpl:<!-- target:mergeTest -->hello {{myName}}!
         * @param {Object|String...} opts 提供相应数据的对象或多个字符串
         * @returns {String} 格式化后的字符串
         */
        parseAllTarget: function () {
            var me = this,
                targetList = {};
            /**
             * 解析所有target
             */
            for (var i in me.originTargetContainer) {
                if (!i) continue;
                targetList[i] = me.originTargetContainer[i];
            }

            for (var i in me.originTargetContainer) {
                if (!i) continue;
                var v = me.originTargetContainer[i];
                for (var j in targetList) {
                    if (!j || i == j) continue;
                    //importRule
                    targetList[j] = targetList[j].replace(new RegExp('<!--\\s*import\\s*:\\s*(' + i + ')\\s*-->', 'g'), v);
                }
            }

            me.parsedTargetContainer = targetList;

            return targetList;
        },
        /**
         * @name 合并模板与数据
         * @public
         * @param {HTMLElement} targetContent  原始模板内容.
         * @param {Object}      model    数据模型
         * @return {String} 替换掉{{varName}}变量后的模板内容.
         */
        merge: function (targetContent, model) {
            return hui.Template.parse(targetContent, model);
        },
        format: function (source, opts) {
            function handler(match, key) {
                var type = String(key).indexOf('!!') === 0 ? 'decode' : String(key).indexOf('!') === 0 ? '' : 'encode',
                    parts = key.replace(/^!!?/, '').split('.'),
                    part = parts.shift(),
                    cur = data,
                    variable;
                while (part) {
                    if (cur[part] !== undefined) {
                        cur = cur[part];
                    }
                    else {
                        cur = undefined;
                        break;
                    }
                    part = parts.shift();
                }

                variable = cur;
                if ('[object Function]' === toString.call(variable)) {
                    variable = variable(key);
                }
                if (undefined !== variable) {
                    variable = String(variable);
                    // encodeURIComponent not encode '
                    var fr = '&|<|>| |\'|"|\\'.split('|'),
                        to = '&amp;|&lt;|&gt;|&nbsp;|&apos;|&quot;|&#92;'.split('|');
                    if (type === 'decode') {
                        for (var i = fr.length - 1; i > -1; i--) {
                            variable = variable.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
                        }
                    }
                    else if (type === 'encode') {
                        for (var i = 0, l = fr.length; i < l; i++) {
                            variable = variable.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
                        }
                    }
                }

                return (undefined === variable ? '' : variable);
            }

            source = String(source);
            var data = Array.prototype.slice.call(arguments, 1),
                toString = Object.prototype.toString;
            if (data.length) {
                data = (data.length == 1 ?
                    /* ie 下 Object.prototype.toString.call(null) == '[object Object]' */
                    (opts !== null && (/\[object (Array|Object)\]/.test(toString.call(opts))) ? opts : data) : data);

                return source.replace(/#\{(.+?)\}/g, handler).replace(/\{\{([^\{]+?)\}\}/g, handler);
            }
            return source;
        },
        error: function (msg) {
            msg = 'Template: ' + msg;
            if (hui.window.console) {
                hui.window.console.log(msg);
            }
            else throw Error(msg);
        },
        varConvert: function (token, model, strMap, str) {
            var s2,
                value,
                c,
                m;
            model = model || {};

            for (var i = 0, ilen = token.length; i < ilen; i++) {
                s2 = token[i];
                if (s2 === ',') continue;

                value = s2[s2.length - 1];
                if (s2.length === 2 || value === '') {
                    throw new Error('Template syntax error: ' + s2 + ' in ' + str);
                }
                value = hui.Template.getExpValue(value, model, strMap);
                // Deal with a=b=, attention: won't want break s2, so use length-1 instead pop()
                for (var j = 0, jlen = s2.length; j < jlen - 1; j++) {
                    if (s2[j] !== '=') {
                        if (s2[j].length > 1 && s2[j].indexOf('.') !== -1) {
                            m = s2[j];
                            m = m.split('.').join('=.=').split('=');

                            c = hui.Template.expCalculate(m, model, strMap, 'keep_var');
                            c.parent[c.child] = value;
                        }
                        else {
                            model[s2[j]] = value;
                        }
                    }
                }
            }
            return model;
        },
        varTokenization: function (str) {
            var list,
                c,
                m,
                notValue = true,
                preQuot = -1,
                isJSON = false,
                preBracket = [],
                lineNum,
                s1 = [],
                s2 = [],
                s3 = [],
                t1 = [],
                t2 = [],
                s4;

            list = String(str).split('');
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                c = list[i];

                // 单引或双引
                if (/^[\'\"]$/.test(c)) { //'
                    if (notValue === true && preQuot === -1) {
                        notValue = false;
                        preQuot = i;
                        t1.push(c);
                        continue;
                    }
                    // 值 !notValue == isValue
                    if (!notValue) {
                        // 前面反斜杠个数
                        lineNum = 0;
                        for (var j = i - 1; j > -1; j--) {
                            if (list[j] === '\\') {
                                lineNum++;
                            }
                            else {
                                j = -1;
                            }
                        }
                        // 个数为偶数且和开始引号相同
                        // 结束引号
                        if (lineNum % 2 === 0) {
                            if (list[preQuot] === c) {
                                t1.push(c);
                                s1.push('{{' + t2.length + '}}');
                                t2.push(t1);
                                t1 = [];

                                notValue = true;
                                preQuot = -1;
                            }
                        }
                        else {
                            t1.push(c);
                        }
                    }
                    // 非值 notValue = true;
                    else {
                        // 开始引号
                        if (preQuot === -1) {
                            notValue = false;
                            preQuot = i;

                            t1.push(c);
                        }
                        // 结束引号
                        else if (list[preQuot] === c) {
                            notValue = true;
                            preQuot = -1;
                        }
                    }
                }
                else {
                    // is String value
                    if (!notValue) {
                        t1.push(c);
                    }
                    // 非值 notValue = true
                    else {
                        if (c + list[i + 1] === '{{') {
                            s1.push(' ');
                            for (var j = i + 2; j < ilen; j++) {
                                if (list[j] + list[j + 1] === '}}') {
                                    i = j + 1;
                                    break;
                                }
                                s1.push(list[j]);
                            }
                            s1.push(' ');
                        }
                        else if (c === '{' || c === '[') {
                            isJSON = true;
                            preBracket.push(c);

                            s1.push(c);
                        }
                        else if (c === '}' || c === ']') {
                            if (preBracket[preBracket.length - 1] === (c === '}' ? '{' : '[')) {
                                preBracket.pop();
                            }
                            if (preBracket.length === 0) {
                                isJSON = false;

                                s1.push(c);
                            }
                        }
                        // 逗号
                        else if (!isJSON && c === ',') {
                            s2.push(s1);
                            s3.push(s2);
                            s3.push(',');
                            s1 = [];
                            s2 = [];
                        }
                        // 等号, 且不是 != , >= , <= , ==
                        else if ((c === '=' || c === '是') && list[i - 1] !== '不' && list[i - 1] !== '!' && list[i - 1] !== '>' &&
                            list[i - 1] !== '<' && list[i - 1] !== '=' && list[i + 1] !== '=') {
                            s2.push(s1);
                            s2.push('=');
                            s1 = [];
                        }
                        else {
                            s1.push(c);
                        }
                    }


                }
            }

            if (t1.join('')) {
                s1.push('{{' + t2.length + '}}');
                t2.push(t1);
            }

            s2.push(s1);
            s3.push(s2);


            for (var i = 0, ilen = s3.length; i < ilen; i++) {
                s4 = s3[i];
                if (Object.prototype.toString.call(s4) === '[object Array]') {
                    for (var j = 0, jlen = s4.length; j < jlen; j++) {
                        if (Object.prototype.toString.call(s4[j]) === '[object Array]') {
                            s4[j] = s4[j].join('');
                        }
                        s4[j] = String(s4[j]).replace(/(^\s+|\s+$)/g, '');
                    }
                }
            }

            for (var i = 0, ilen = t2.length; i < ilen; i++) {
                c = t2[i];
                if (c[c.length - 1] === '"' || c[c.length - 1] === '\'') {
                    c.pop();
                }
                if (c[0] === '"' || c[0] === '\'') {
                    c.shift();
                }
                t2[i] = c.join('');
            }

            for (var i = 0, ilen = s3.length; i < ilen; i++) {
                c = s3[i];
                if (Object.prototype.toString.call(c) === '[object Array]') {
                    for (var j = 0, jlen = c.length; j < jlen; j++) {
                        m = c[j];
                        c[j] = hui.Template.overloadOperator(m);
                    }
                }
                else {
                    s3[i] = hui.Template.overloadOperator(c);
                }
            }

            return {
                token: s3,
                strMap: t2
            };
        },
        overloadOperator: function (str) {
            var opList = [
                '有', '.',
                '的', '.',
                '自加加', '++',
                '自减减', '--',
                '非', '!',
                '正', '+',
                '负', '-',
                '乘以', '*',
                '除以', '/',
                '求余', '%',
                '加上', '+',
                '减去', '-',
                '不大于', '<=',
                '不小于', '>=',
                '不等于', '!=',
                '不是', '!==',
                '恒等于', '===',
                '真的是', '===',
                '不恒等于', '!==',
                '大于', '>',
                '小于', '<',
                '等于', '==',
                '且', '&&',
                '或', '||',
                '实体', '{}',
                '数组', '[]'
            ];
            for (var i = 0, ilen = opList.length; i < ilen;) {
                str = str.split(opList[i++]).join(opList[i++]);
            }
            return str;
        },
        getExpValue: function (v1, model, strMap) {
            v1 = String(v1);
            strMap = strMap || [];
            var keyword = {
                'null': {
                    v: null
                },
                'undefined': {
                    v: undefined
                },
                'true': {
                    v: true
                },
                'false': {
                    v: false
                }
            };
            var value = v1,
                v = v1;
            // Number
            if (v.replace(/^[+\-]?(\d+\.)?\d+/g, '') === '' ||
                '"\''.indexOf(v.substr(0, 1)) !== -1 ||
                '{['.indexOf(v.substr(0, 1)) !== -1 ||
                keyword[v] ||
                v.replace(/^[a-zA-Z_]+[a-zA-Z0-9_]*/g, '') === '') {
                value = hui.Template.getKeyValue(v, model, strMap);
            }
            // Exp
            else {
                // != , >= , <= , ==
                var token1 = hui.Template.expTokenization(v, model);
                var token2 = hui.Template.expConvertBracket(token1, model, strMap);
                var token3 = hui.Template.expConvertTree(token2, model, strMap);
                value = hui.Template.expCalculate(token3, model, strMap);
            }
            // console.log(value);
            return value;
        },
        // <!-- if: a = 123 -->  =>  <!-- var: a = 123 --> <!-- if: a -->
        //hui.Template.expBuildTree(['w.a','&&','w.a','/','w.a'])
        expCalculate: function (list, model, strMap, keep_var) {
            if (!list.opr) {
                if (list.length === 1) {
                    if (Object.prototype.toString.call(list[0]) === '[object Array]') {
                        result = hui.Template.expCalculate(list[0], model, strMap, keep_var);
                    }
                    // a[aa]
                    else {
                        result = hui.Template.getKeyValue(list[0], model, strMap);
                    }
                    return result;
                }

                for (var i = 0, ilen = list.length; i < ilen; i++) {
                    if (hui.Template.expIsOperator(list[i])) {
                        list.opr = list[i];
                        break;
                    }
                }
            }

            var c, m, result, data;
            /* var degree = {
                '.': 11,
                '的': 11,
                '[': 11,
                ']': 11,
                '(': 10,
                ')': 10,
                '++': 9,
                '自加加': 9,
                '--': 9,
                '自减减': 9,
                '^!': 8,
                '非': 8,
                '^+': 8,
                '正': 8,
                '^-': 8,
                '负': 8,
                '*': 7,
                '乘以': 7,
                '/': 7,
                '除以': 7,
                '%': 7,
                '求余': 7,
                '+': 6,
                '加上': 6,
                '-': 6,
                '减去': 6,
                '<': 5,
                '小于': 5,
                '<=': 5,
                '不大于': 5,
                '>': 5,
                '大于': 5,
                '>=': 5,
                '不小于': 5,
                '==': 4,
                '等于': 4,
                '!=': 4,
                '不等于': 4,
                '===': 4,
                '恒等于': 4,
                '!==': 4,
                '不恒等于': 4,
                '&&': 3,
                '且': 3,
                '||': 2,
                '或': 2
            };*/

            if (list.opr === '++' || list.opr === '--') {
                c = list[0] === '++' || list[0] === '--' ? list[1] : list[0];
                if (Object.prototype.toString.call(c) !== '[object Array]' && (!c || c.replace(/^[a-zA-Z_]+[a-zA-Z0-9_]*/g, '') !== '')) {
                    throw new Error('Syntax error: "++","--" in ' + hui.Template.format(list.join(' '), strMap));
                }
                c = c.join ? hui.Template.expCalculate(c, model, strMap, 'keep_var') : {
                    parent: model,
                    child: c
                };

                result = c.parent[c.child];
                c.parent[c.child] = result + (list.opr === '++' ? 1 : -1);
                result = list[0] === '++' || list[0] === '--' ? c.parent[c.child] : result;

            }
            else if (list.opr === '.') {
                for (var i = 0, ilen = list.length; i < ilen; i++) {
                    c = list[i];
                    if (Object.prototype.toString.call(c) === '[object Array]') {
                        c = hui.Template.expCalculate(c, model, strMap);
                    }
                    if (c && String(c).indexOf('{{') === 0) {
                        c = strMap[c.replace(/(^{{|}}$)/g, '')];
                    }
                    list[i] = c;
                }

                data = model;
                var ilen = list.length + (keep_var === 'keep_var' ? -1 : 0);

                for (var i = 0; i < ilen; i++) {
                    c = list[i];
                    if (!data) {
                        break;
                    }
                    data = data[c];
                    i++;
                }
                result = keep_var === 'keep_var' ? {
                    parent: data || {},
                    child: list[list.length - 1]
                } : data;
            }
            else {
                for (var i = 0, ilen = list.length; i < ilen; i++) {
                    c = list[i];
                    if (Object.prototype.toString.call(c) === '[object Array]') {
                        c = hui.Template.expCalculate(c, model, strMap);
                        list[i] = c;
                    }
                    else {
                        list[i] = hui.Template.expIsOperator(c) ? list[i] : hui.Template.getKeyValue(c, model, strMap);
                    }

                }

                if (list.opr === '!') {
                    result = list.pop();
                    for (var i = list.length - 1; i > -1; i--) {
                        result = !m;
                    }
                }
                else if (list.opr === '?') {
                    c = list[0];
                    if (c) {
                        result = list[2];
                    }
                    else {
                        result = list[4];
                    }
                }
                else if (list.opr === '||') {
                    result = false || list[0];
                    for (var i = 1, ilen = list.length; i < ilen && !result; i++) {
                        c = list[i];
                        if (c === '||' && !result) {
                            m = list[i + 1];
                            result = result || m;
                        }
                        i++;
                    }
                }
                else if (list.opr === '&&') {
                    result = true && list[0];
                    for (var i = 1, ilen = list.length; i < ilen && result; i++) {
                        c = list[i];
                        if (c === '&&' && result) {
                            m = list[i + 1];
                            result = result && m;
                        }
                        i++;
                    }
                }
                else if (list.opr === '!==' || list.opr === '===' || list.opr === '!=' || list.opr === '==') {
                    result = list[0];
                    for (var i = 1, ilen = list.length; i < ilen; i++) {
                        c = list[i];
                        m = list[i + 1];
                        if (c === '!==' || c === '!=') {
                            result = String(result) !== String(m);
                        }
                        else if (c === '===' || c === '==') {
                            result = String(result) === String(m);
                        }
                        i++;
                    }
                }
                else if (list.opr === '>' || list.opr === '>=' || list.opr === '<' || list.opr === '<=') {
                    result = list[0];
                    for (var i = 1, ilen = list.length; i < ilen; i++) {
                        c = list[i];
                        m = list[i + 1];
                        if (c === '>') {
                            result = result > m;
                        }
                        else if (c === '>=') {
                            result = result >= m;
                        }
                        else if (c === '<') {
                            result = result < m;
                        }
                        else if (c === '<=') {
                            result = result <= m;
                        }
                        i++;
                    }
                }
                else if (list.opr === '+' || list.opr === '-') {
                    if (list[0] === '+' || list[0] === '-') {
                        result = list.pop();
                        for (var i = list.length - 1; i > -1; i--) {
                            result = list[i] === '-' ? 0 - result : result;
                        }
                    }
                    else {
                        result = list[0];
                        for (var i = 1, ilen = list.length; i < ilen; i++) {
                            c = list[i];
                            m = list[i + 1];
                            if (c === '+') {
                                result = result + m;
                            }
                            else if (c === '-') {
                                result = result - m;
                            }
                            i++;
                        }
                    }
                }
                else if (list.opr === '*' || list.opr === '/' || list.opr === '%') {
                    result = list[0];
                    for (var i = 1, ilen = list.length; i < ilen; i++) {
                        c = list[i];
                        m = list[i + 1];
                        if (c === '*') {
                            result = result * m;
                        }
                        else if (c === '/') {
                            result = result / m;
                        }
                        else if (c === '%') {
                            result = result % m;
                        }
                        i++;
                    }
                }
            }

            return result;
        },
        getKeyValue: function (v1, model, strMap, keep_str) {
            v1 = String(v1);
            strMap = strMap || [];
            var keyword = {
                'null': {
                    v: null
                },
                'undefined': {
                    v: undefined
                },
                'true': {
                    v: true
                },
                'false': {
                    v: false
                }
            };
            var value = v1,
                v = v1;

            // Number
            if (v.replace(/^[+\-]?(\d+\.)?\d+/g, '') === '') {
                value = Number(v);
            }
            // String
            else if (~'"\''.indexOf(v.substr(0, 1))) {
                value = v.replace(/(^[\"\']|[\"\']$)/g, ''); //"
            }
            // {{0}}
            else if (v.indexOf('{{') > -1) {
                value = hui.Template.format(strMap[v.replace(/(^{{|}}$)/g, '')], model);
                //value = v;
            }
            // JSON
            else if (~'{['.indexOf(v.substr(0, 1))) {
                v = v1.replace(/{{(\d+)}}/g, function (match, key) {
                    return strMap[key];
                });

                value = (new Function('return ' + v))();
                value = value;
            }
            // null, undefined, true, false
            else if (keyword[v]) {
                value = keyword[v].v;
            }
            // model[v]
            else {
                //else if (v.replace(/^[a-zA-Z_]+[a-zA-Z0-9_]*/g, '') === '') {
                value = model[v];
            }

            return value;
        },
        // b.a !== {{0}}, b[{{1}}] !== {{2}}, a+b
        expTokenization: function (str) {
            var list,
                pre,
                next,
                c,
                isOperator = false,
                s1 = [],
                s2 = [];

            list = String(str).split('');
            for (var i = 0, ilen = list.length; i < ilen; i++) {
                c = list[i];
                pre = ',' + String(list[i - 1]) + c + ',';
                next = String(list[i - 1]) + c + String(list[i + 1]);
                if ('[]()+-!*/%<=>&|?:,.'.indexOf(c) !== -1) {
                    isOperator = true;
                    if (',++,--,==,!=,>=,<=,&&,||,'.indexOf(pre) !== -1 || /\d\.\d/.test(next)) {
                        s1.push(c);
                    }
                    else {
                        if (s1.length) {
                            s2.push(s1);
                        }
                        s1 = [];
                        s1.push(c);
                    }
                }
                else if (c + list[i + 1] === '{{') {
                    if (s1.length) {
                        s2.push(s1);
                    }
                    s1 = [];
                    for (var j = i; j < ilen; j++) {
                        s1.push(list[j]);
                        if (list[j] + list[j + 1] === '}}') {
                            i = j + 1;
                            break;
                        }
                    }
                    s2.push(s1);
                    s1 = [];
                }
                else if (c === ' ' || c === '\t') {
                    continue;
                }
                else if (list[i - 1] === '.' && '0123456789'.indexOf(c) !== -1) {
                    s1.push(c);
                }
                else {
                    if (isOperator) {
                        isOperator = false;
                        if (s1.length) {
                            s2.push(s1);
                        }
                        s1 = [];
                    }
                    s1.push(c);
                }
            }

            if (s1.length) {
                s2.push(s1);
            }

            for (var i = 0, ilen = s2.length; i < ilen; i++) {
                if (s2[i] && s2[i].join) {
                    s2[i] = s2[i].join('');
                }
            }

            return s2;
        },
        expConvertBracket: function (token, model, strMap) {
            //
            token = token || [];
            var root = [],
                parent = null,
                cur = root,
                list = [root],
                c;
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '(' || c === '[') {
                    parent = cur;
                    if (c === '[') {
                        cur.push('.');
                    }
                    cur = [];

                    parent.push(cur);
                    list.push(cur);

                }
                else if (list.length > 1 && c === ')' || c === ']') {
                    list.pop();
                    cur = parent || cur;
                    if (c === ']') {
                        //cur.push(c);
                    }
                    parent = list[list.length - 2];
                }
                else {
                    cur.push(c);
                }

            }

            return root;
        },
        expConvertTree: function (token, model, strMap) {
            for (var i = 0, ilen = token.length; i < ilen; i++) {
                if (Object.prototype.toString.call(token[i]) === '[object Array]') {
                    token[i] = hui.Template.expConvertTree(token[i]);
                    i = i;
                }
            }
            return hui.Template.expBuildTree(token);
        },
        expBuildTree: function (token) {
            token = token && token.length && token.join ? token : [];

            var degree = {
                '.': 11
                ,'[': 11
                ,']': 11
                ,'(': 10
                ,')': 10
                ,'++': 9
                ,'--': 9
                ,'^!': 8
                ,'^+': 8
                ,'^-': 8
                ,'*': 7
                ,'/': 7
                ,'%': 7
                ,'+': 6
                ,'-': 6
                ,'<': 5
                ,'<=': 5
                ,'>': 5
                ,'>=': 5
                ,'==': 4
                ,'!=': 4
                ,'===': 4
                ,'!==': 4
                ,'&&': 3
                ,'||': 2
                ,'的': 11
                ,'自加加': 9
                ,'非': 8
                ,'自减减': 9
                ,'正': 8
                ,'负': 8
                ,'乘以': 7
                ,'除以': 7
                ,'求余': 7
                ,'加上': 6
                ,'减去': 6
                ,'小于': 5
                ,'不大于': 5
                ,'大于': 5
                ,'不小于': 5
                ,'等于': 4
                ,'不等于': 4
                ,'恒等于': 4
                ,'不恒等于': 4
                ,'且': 3
                ,'或': 2
            };
            var c,
                pre,
                nxt,
                cd,
                newtoken,
                n;
            // .
            token = token;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '.') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid Dot(.) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // ++, --
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '++' || c === '--') {
                    // i++
                    if (hui.Template.expIsOperand(token[i - 1]) && !hui.Template.expIsOperand(token[i + 1])) {
                        n = [];
                        n.push(newtoken.pop());
                        n.push(c);
                        n.lev = degree[c];
                        n.opr = c;
                        newtoken.push(n);
                    }
                    // ++i
                    else if (!hui.Template.expIsOperand(token[i - 1]) && hui.Template.expIsOperand(token[i + 1])) {
                        n = [];
                        n.push(c);
                        n.push(token[i + 1]);
                        n.lev = degree[c];
                        n.opr = c;
                        newtoken.push(n);
                        i++;
                    }
                    else {
                        throw new Error('SyntaxError: invalid Increment(++),Decrement(--) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // ! + -
            token = newtoken;
            newtoken = [token.pop()];
            for (var i = token.length - 1; i > -1; i--) {
                c = token[i];
                if ((c === '+' || c === '-' || c === '!') && (hui.Template.expIsOperator(token[i - 1]) || i === 0)) {
                    // ! ! ! + - - - + a
                    cd = degree['^' + c];
                    pre = newtoken[0];
                    if (hui.Template.expIsOperand(pre)) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.unshift(c);
                        }
                        else {
                            pre = [];
                            pre.unshift(newtoken.shift());
                            pre.unshift(c);
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.unshift(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid Negative(+),Positive(-) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.unshift(c);
                }
            }
            // * / %
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '*' || c === '/' || c === '%') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid MUL(*),DIV(/),(MOD)% operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a + b
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '+' || c === '-') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid ADD(+) or SUB(-) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a >= b
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '>' || c === '>=' || c === '<' || c === '<=') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid Morethan(>,>=),Lessthan(<=,<) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a === b
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '==' || c === '!=' || c === '===' || c === '!==') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid Equal(==,!==) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a && b
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '&&') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid AND(&&) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a || b
            token = newtoken;
            newtoken = [];
            for (var i = 0, len = token.length; i < len; i++) {
                c = token[i];
                if (c === '||') {
                    cd = degree[c];
                    pre = newtoken[newtoken.length - 1];
                    // a.b
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(token[i + 1])) {
                        if (pre && pre.lev && pre.lev === cd) {
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                        }
                        else {
                            pre = [];
                            pre.push(newtoken.pop());
                            pre.push(c);
                            pre.push(token[i + 1]);
                            i++;
                            pre.lev = cd;
                            pre.opr = c;
                            newtoken.push(pre);
                        }
                    }
                    else {
                        throw new Error('SyntaxError: invalid OR(||) operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.push(c);
                }
            }
            // a ? b : c
            token = newtoken;
            newtoken = [];
            for (var i = token.length - 1; i > -1; i--) {
                c = token[i];
                if (c === '?') {
                    // a ? b : c
                    cd = degree[c];
                    pre = token[i - 1];
                    if (hui.Template.expIsOperand(pre) && hui.Template.expIsOperand(newtoken[0]) && newtoken[1] === ':' && hui.Template.expIsOperand(newtoken[2])) {
                        nxt = [];
                        nxt.push(pre);
                        nxt.push(c);
                        nxt.push(newtoken.shift());
                        nxt.push(newtoken.shift());
                        nxt.push(newtoken.shift());
                        i--;

                        nxt.lev = cd;
                        nxt.opr = c;
                        newtoken.unshift(nxt);
                    }
                    else {
                        throw new Error('SyntaxError: invalid "A ? B : C"  operand in "' + token[i - 1] + ' ' + token[i] + ' ' + token[i + 1] + '"');
                    }
                }
                else {
                    newtoken.unshift(c);
                }
            }

            return newtoken;
        },
        expIsOperator: function (key) {
            key = key === null || key === undefined ? '' : key;
            if (Object.prototype.toString.call(key) === '[object Array]') {
                key = '';
            }

            key = String(key).replace(/(^\s+|\s+$)/g, '');
            var result = key.length < 4 && ',+,-,*,/,%,&&,||,!,==,===,!=,!==,>,<,>=,<=,.,[,],(,),'.indexOf(',' + key + ',') != -1;
            return result;
        },
        expIsOperand: function (v) {
            return v !== null && v !== undefined && !hui.Template.expIsOperator(v);
        },

        // Regular Expressions for parsing tags and attributes
        startTag: /^<!--\s*([A-Za-z0-9\u4e00-\u9fa5]+):(.*?)-->/,
        endTag: /^<!--\s*\/([A-Za-z0-9\u4e00-\u9fa5]+)\s*-->/,

        // Block Elements
        typeBlock: {
            'if': 1,
            'elif': 1,
            'else': 1,
            'for': 1
        },

        // Elements that you can':1,' intentionally':1,' leave open
        // (and which close themselves)
        typeCloseSelf: {
            'var': 1,
            'use': 1
        },
        typeEndAndStart: {
            'elif': 1,
            'else': 1
        },
        typeScope: {
            'for': 1,
            'use': 1,
            'html': 1
        },
        // Strict xml model!!
        parse: function (html, model, root) {
            var me = this;
            var stack = me.tokenization(html);
            if (root === undefined) {
                // 根节点 
                root = hui.Template.createElement('html', {
                    childNodes: [],
                    nodeType: 'startTag',
                    labelValue: ''
                });
                hui.Template.rootNode = root;
            }
            if (model) {
                root.scopeChain = root.scopeChain || {};
                for (var i in model) {
                    if (model.hasOwnProperty(i)) {
                        root.scopeChain[i] = model[i];
                    }
                }
            }
            me.treeConstruction(stack, root);

            var c = root;
            var result = '';
            var tplList = [];
            for (var j = 0, jlen = c.childNodes.length; j < jlen; j++) {
                tplList.push(me.mergeModel(c.childNodes[j]));
            }
            result = tplList.join('');

            return result;
            //me.domtree;
        },
        overloadTagName: function (node) {
            var tagNameList = [
                '安排', 'var',
                '定义', 'var',
                '设定', 'var',
                '如果', 'if',
                '如果结束', 'if',
                '假如', 'if',
                '假设', 'if',
                '假设结束', 'if',
                '又假设', 'elif',
                '又假如', 'elif',
                '否则', 'else',
                '循环', 'for',
                '循环结束', 'for'
            ];
            if (node) {
                for (var i = 0, ilen = tagNameList.length; i < ilen; i++) {
                    if (node.tagName === tagNameList[i++]) {
                        node.tagName = tagNameList[i];

                    }
                }
            }
            return node;
        },

        // Token serial
        tokenization: function (html) {
            var me = this,
                tokenserial = [],
                index,
                m, n,
                token,
                nodeValue,
                match,
                html = String(html);


            // <!--comment--> <html>1234</html>
            while (html) {
                // start tag
                if (html.indexOf('<!--') === 0 && me.startTag.test(html)) {
                    match = html.match(me.startTag);

                    token = {
                        tagName: match[1],
                        nodeValue: match[2],
                        labelValue: match[0],
                        nodeType: 'startTag'
                    };
                    token = hui.Template.overloadTagName(token);
                    token.nodeType = me.typeCloseSelf[token.tagName] ? 'selfClose' : (me.typeEndAndStart[token.tagName] ? 'typeEndAndStart' : token.nodeType);
                    tokenserial.push(token);

                    html = html.substring(match[0].length);
                }
                // end tag
                else if (html.indexOf('<!--') === 0 && me.endTag.test(html)) {
                    match = html.match(me.endTag);

                    token = {
                        tagName: match[1],
                        nodeType: 'endTag'
                    };
                    tokenserial.push(hui.Template.overloadTagName(token));

                    html = html.substring(match[0].length);
                }
                // Comment
                else if (html.indexOf('<!--') === 0) {
                    m = html.indexOf('<!--');
                    n = html.indexOf('-->', m + 4);
                    n = n == -1 ? html.length : n;
                    nodeValue = html.substring(m + 4, n);
                    token = {
                        tagName: 'comment',
                        nodeValue: nodeValue,
                        labelValue: '<!--' + nodeValue + '-->',
                        nodeType: 'selfClose'
                    };
                    tokenserial.push(hui.Template.overloadTagName(token));

                    html = html.substring(0, m) + html.substring(n + 3, html.length);
                }
                // text
                else {
                    m = html.indexOf('<!--', 1);
                    index = m == -1 ? html.length : m;
                    nodeValue = html.substring(0, index);

                    token = {
                        tagName: 'nodetext',
                        nodeValue: nodeValue,
                        labelValue: nodeValue,
                        nodeType: 'selfClose'
                    };
                    tokenserial.push(hui.Template.overloadTagName(token));
                    html = html.substring(index, html.length);
                }
            }

            return tokenserial;
        },
        treeConstruction: function (tokens, parentNode) {
            var me = this,
                domtree = parentNode || hui.Template.rootNode,
                curentParent = domtree,
                token,
                elem,
                parentElem;
            for (var i = 0, len = tokens.length; i < len; i++) {
                token = tokens[i];

                if (token.nodeType == 'selfClose') {
                    elem = me.createElement(token.tagName, token);
                    curentParent.childNodes.push(elem);
                    // elem.parentNode = curentParent.getGUID();
                    elem.parentNode = curentParent;
                }
                else if (token.nodeType == 'startTag') {
                    // 'if,elif,else' is special.
                    if (token.tagName == 'if') {
                        elem = me.createElement('ifif', {});
                        curentParent.childNodes.push(elem);
                        // elem.parentNode = curentParent.getGUID();
                        elem.parentNode = curentParent;
                        elem.childNodes = [];
                        curentParent = elem;
                    }

                    elem = me.createElement(token.tagName, token);
                    curentParent.childNodes.push(elem);
                    // elem.parentNode = curentParent.getGUID();
                    elem.parentNode = curentParent;

                    // Not empty tag
                    if (!me.typeCloseSelf[token.tagName]) {
                        elem.childNodes = [];
                        curentParent = elem;
                    }
                }
                else if (token.nodeType == 'endTag') {
                    if (!me.typeCloseSelf[token.tagName]) {

                        if (token.tagName == 'if' && ~',if,elif,else,'.indexOf(',' + curentParent.tagName)) {
                            parentElem = curentParent.parentNode;
                            if (parentElem.tagName == 'ifif') {
                                curentParent = parentElem.parentNode;
                            }
                        }
                        else if (token.tagName == curentParent.tagName) {
                            curentParent = curentParent.parentNode;
                        }
                        // Only deal with typeBlock!
                        else if (me.typeBlock[token.tagName]) {
                            parentElem = curentParent;
                            while (parentElem) {
                                if (parentElem.tagName == token.tagName) {
                                    curentParent = parentElem.parentNode;
                                }
                                else {
                                    parentElem = parentElem.parentNode;
                                }
                            }
                        }
                    }
                }
                else if (token.nodeType == 'typeEndAndStart') {
                    if (me.typeEndAndStart[token.tagName]) {
                        if (~',if,elif,'.indexOf(',' + curentParent.tagName + ',') && ~',elif,else,'.indexOf(',' + token.tagName)) {
                            curentParent = curentParent.parentNode;
                        }

                        elem = me.createElement(token.tagName, token);
                        curentParent.childNodes.push(elem);
                        // elem.parentNode = curentParent.getGUID();
                        elem.parentNode = curentParent;

                        // Not empty tag
                        if (!me.typeCloseSelf[token.tagName]) {
                            elem.childNodes = [];
                            curentParent = elem;
                        }
                    }
                }
            }
            return domtree;

        },
        createElement: function (tagName, options) {
            var me = this,
                clazz = hui.Template.NodeElement,
                elem = new clazz();

            options = options || {};
            options.tagName = tagName;

            for (var i in options) {
                elem[i] = options[i];
            }
            if (me.typeScope[String(tagName).toLowerCase()]) {
                elem.scopeChain = elem.scopeChain || {};
            }
            return elem;
        },
        mergeModel: function (nodeItem) {
            var me = this,
                str,
                k,
                v,
                c,
                list,
                tplList,
                model,
                result;
            if (nodeItem && nodeItem.tagName) {
                var tagName = String(nodeItem.tagName).toLowerCase();

                if (tagName === 'var') {
                    str = nodeItem.nodeValue;
                    list = hui.Template.varTokenization(str);
                    result = '';
                    model = nodeItem.getScopeChainModel();
                    hui.Template.varConvert(list.token, model, list.strMap, str);
                    nodeItem.updateScopeChainModel(model);
                }
                else if (tagName === 'ifif') {
                    model = nodeItem.getScopeChainModel();
                    result = '';
                    for (var i = 0, ilen = nodeItem.childNodes.length; i < ilen; i++) {
                        c = nodeItem.childNodes[i];
                        if (c.tagName === 'else') {
                            tplList = [];
                            for (var j = 0, jlen = c.childNodes.length; j < jlen; j++) {
                                tplList.push(me.mergeModel(c.childNodes[j]));
                            }
                            result = tplList.join('');
                            break;
                        }
                        else {
                            k = hui.Template.varTokenization(c.nodeValue);
                            var k2 = hui.Template.getExpValue(k.token[0][0], model, k.strMap);
                            if (k2) {
                                tplList = [];
                                for (var j = 0, jlen = c.childNodes.length; j < jlen; j++) {
                                    tplList.push(me.mergeModel(c.childNodes[j]));
                                }
                                result = tplList.join('');
                                break;
                            }
                        }
                    }
                }
                else if (tagName === 'for') {
                    var scopeChain = nodeItem.scopeChain;
                    str = nodeItem.nodeValue;
                    model = nodeItem.getScopeChainModel();

                    v = str.split(' in ');
                    k = v[0].replace(/(^\s+|\s+$)/g, '').replace(/(^{{|}}$)/g, '');
                    var vname = v[1].replace(/(^\s+|\s+$)/g, '').replace(/(^{{|}}$)/g, '');
                    var str2;
                    var start;
                    var end;
                    var step = 1;
                    var tail = false;
                    if (vname.indexOf('..') !== -1) {
                        if (vname.indexOf('...') !== -1) {
                            tail = true;
                            vname = vname.replace('...', '..');
                        }
                        str2 = vname.split(' step ');
                        step = Number((str2[1] ? str2[1].replace(/\s/g, '') : step) || step);

                        start = Number(str2[0].split('..')[0]);
                        end = Number(str2[0].split('..')[1]);
                        list = [];
                        for (var i = start; i < end || (tail && i === end); i += step) {
                            list.push(i);
                        }
                    }
                    else {
                        list = hui.Template.getExpValue(vname, model);
                    }


                    if (Object.prototype.toString.call(list) !== '[object Array]') {
                        throw new Error('SyntaxError: invalid "list" operand in "' + str + '"');
                    }

                    c = nodeItem;
                    result = '';
                    tplList = [];
                    for (var i in list) {
                        if (list.hasOwnProperty(i)) {
                            scopeChain[k] = model[k] = list[i];
                        }
                        for (var j = 0, jlen = c.childNodes.length; j < jlen; j++) {
                            tplList.push(me.mergeModel(c.childNodes[j]));
                        }
                    }
                    result = tplList.join('');
                    return result;
                }
                /**
                '<!-- use: item(main=${p.name}, sub=${p.email}) -->',
                '<!-- target: item --><li>${main}[${sub}]</li>'
                */
                else if (tagName === 'use') {
                    str = nodeItem.nodeValue.replace(/(^\s+|\s+$)/g, '');
                    model = nodeItem.getScopeChainModel();
                    nodeItem.childNodes = [];

                    var varStr = str.substring(str.indexOf('(') + 1, str.lastIndexOf(')')),
                        targetName = str.substring(0, str.indexOf('(')),
                        targetContent = hui.Template.getTarget(targetName);
                    //varStr = hui.Template.format(varStr, model);
                    me.parse('<!--var:' + varStr + '-->', model, nodeItem);
                    model = nodeItem.getScopeChainModel();
                    result = me.parse(targetContent, model, nodeItem);
                }
                else if (tagName === 'nodetext') {
                    str = nodeItem.nodeValue;
                    model = nodeItem.getScopeChainModel();
                    result = hui.Template.format(str, model).replace(/\{(\\*)\\\{/g, '{$1{').replace(/\}(\\*)\\\}/g, '}$1}');
                }
                else {
                    result = nodeItem.labelValue;
                }
            }
            return result;
        }

    };

    hui.Template.NodeElement = function (options) {
        this.nodeValue = '';
        this.guid = hui.Template.NodeElement.makeGUID();
    };
    hui.Template.NodeElement.prototype = {
        getGUID: function () {
            var me = this;
            return me.guid;
        },
        getScopeChain: function () {
            var me = this,
                parent = me,
                result = [],
                typeScope = hui.Template.typeScope;
            while (parent) {
                if (typeScope[String(parent.tagName).toLowerCase()]) {
                    result.unshift(parent.scopeChain);
                }
                parent = parent.parentNode;
            }
            return result;
        },
        getScopeChainModel: function () {
            var me = this,
                list = me.getScopeChain(),
                model = {};
            for (var j = list.length - 1; j > -1; j--) {
                for (var i in list[j]) {
                    if (!model.hasOwnProperty(i)) {
                        model[i] = list[j][i];
                    }
                }
            }
            return model;
        },
        updateScopeChainModel: function (model) {
            var me = this,
                list = me.getScopeChain();
            for (var i in model) {
                if (model.hasOwnProperty(i)) {
                    for (var j = list.length - 1; j > -1; j--) {
                        if (list[j].hasOwnProperty(i)) {
                            list[j][i] = model[i];
                            j = -1;
                            i = undefined;
                        }
                    }
                    if (i !== undefined) {
                        list[list.length - 1][i] = model[i];
                    }
                }
            }

        }
    };
    /**
     * @name 获取唯一id
     * @public
     * @return {String}
     */
    hui.Template.NodeElement.makeGUID = (function () {
        var guid = 1000; // 0 -> root
        return function () {
            return String('tpl_' + guid++);
        };
    })();

    hui.format = hui.Template.format;
});
'::hui_textinput::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   


/**
 * @name 文本输入框控件
 * @public
 * @author haiyang5210
 * @date 2014-11-14 23:51
 * @param {Object} options 控件初始化参数.
 */

hui.define('hui_textinput', ['hui_control', 'hui_util'], function () {

    hui.TextInput = function (options, pending) {
        hui.TextInput.superClass.call(this, options, 'pending');

        if (this.value !== undefined) {
            this.value = String(this.value);
        }
        // useAgent: false <input ui="type:'TextInput'", true <div ui="type:'TextInput'"
        this.useAgent = false;
        this.autoHideError = this.autoHideError === undefined ? false : this.autoHideError;
        this.autoValidate = this.autoValidate === undefined ? false : this.autoValidate;

        //进入控件处理主流程!
        if (pending != 'pending') {
            this.enterControl();
        }
    };

    hui.TextInput.prototype = {
        /**
         * @name 全角转半角
         */
        doDBC2SBC: function (str) {
            var result = '';
            str = str === undefined || str === null ? '' : String(str);
            for (var i = 0; i < str.length; i++) {
                var code = str.charCodeAt(i); //获取当前字符的unicode编码
                if (code >= 65281 && code <= 65373) { //在这个unicode编码范围中的是所有的英文字母已及各种字符
                    result += String.fromCharCode(str.charCodeAt(i) - 65248); //把全角字符的unicode编码转换为对应半角字符的unicode码
                }
                else if (code == 12288) { //空格
                    result += String.fromCharCode(str.charCodeAt(i) - 12288 + 32);
                }
                else {
                    result += str.charAt(i);
                }
            }
            return result;
        },
        /**
         * @name 获取文本输入框的值
         * @public
         * @return {String}
         */
        getValue: function () {
            var me = this,
                value = me.getInput().value;
            if (me.DBC2SBC) {
                value = me.doDBC2SBC(value);
            }
            if (me.valueEncode) {
                value = hui.Control.encode(value);
            }
            return value;
        },

        /**
         * @name 设置文本输入框的值
         * @public
         * @param {String} value
         */
        setValue: function (value) {
            if (this.isReadonly() || this.isDisabled()) {
                return;
            }
            var me = this;
            value = value === undefined ? '' : value;

            if (me.DBC2SBC) {
                value = me.doDBC2SBC(value);
            }

            if (me.valueEncode) {
                value = hui.Control.encode(value);
            }

            me.getChangeHandler(value);

            me.getInput().value = value;
            if (value) {
                me.hidePlaceholder();
                me.showEye();
                //this.getFocusHandler();
            }
            else {
                me.showPlaceholder();
                me.hideEye();
                //this.getBlurHandler();
            }
        },

        /**
         * @name 设置输入控件的title提示
         * @public
         * @param {String} title
         */
        setTitle: function (title) {
            this.getMain().setAttribute('title', title);
        },

        /**
         * @name 将文本框设置为不可写
         * @public
         */
        disable: function (disabled) {
            if (typeof disabled === 'undefined') {
                disabled = true;
            }
            if (disabled) {
                this.getMain().disabled = 'disabled';
            }
            else {
                this.getMain().removeAttribute('disabled');
            }
        },

        /**
         * @name 设置控件为只读
         * @public
         * @param {Object} readonly
         */
        setReadonly: function (readonly) {
            readonly = !!readonly;
            this.getMain().readOnly = readonly;
            /*this.getMain().setAttribute('readonly', readonly);*/
            this.readonly = readonly;
        },
        getInput: function () {
            var me = this,
                main = me.getMain(),
                input,
                input = me.useAgent ? hui.f(me.getClass('text')) : main;
            return input;
        },
        getPlaceholder: function () {
            var me = this,
                main = me.getMain(),
                input,
                input = me.useAgent ? hui.f(me.getClass('placeholder')) : hui.util.findSiblingByClassName(main, me.getClass('placeholder'), 'pre');
            return input;
        },
        getEye: function () {
            var me = this,
                main = me.getMain(),
                input,
                input = me.useAgent ? hui.f(me.getClass('eye')) : hui.util.findSiblingByClassName(main, me.getClass('eye'), 'pre');
            return input;
        },
        renderInput: function () {
            var me = this,
                main = me.getMain(),
                tpl = '<input type="text" class="{{0}}" />';
            if (me.useAgent) {
                hui.appendHTML(main, hui.Control.format(tpl, me.getClass('text')));
            }
        },
        renderPlaceholder: function () {
            var me = this,
                main = me.getMain(),
                elem = me.getPlaceholder();
            if (!elem) {
                elem = document.createElement('SPAN');
                elem.className = me.getClass('placeholder');
                me.setInnerHTML(elem, me.placeholder);
                if (me.useAgent) {
                    main.appendChild(elem);
                    main.insertBefore(elem, main.firstChild);
                }
                else {
                    main.parentNode.insertBefore(elem, main.parentNode.firstChild);
                }
            }
        },
        renderEye: function () {
            var me = this,
                main = me.getMain(),
                tpl = '<a href="#nogo" onmousedown="hui.Control.getById(\'{{1}}\').onmousedown()" onmouseup="hui.Control.getById(\'{{1}}\').onmouseup()" class="{{0}}">Show</a>',
                elem = me.getEye();
            if (!elem) {
                elem = hui.util.getDom(hui.Control.format(tpl, me.getClass('eye'), me.getId()))[0];

                if (me.useAgent) {
                    main.appendChild(elem);
                    main.insertBefore(elem, main.firstChild);
                }
                else {
                    main.parentNode.insertBefore(elem, main.parentNode.firstChild);
                }
            }
        },
        /**
         * @name 渲染控件
         * @protected
         * @param {Object} main 控件挂载的DOM.
         */
        render: function () {
            hui.TextInput.superClass.prototype.render.call(this);
            var me = this,
                main = me.getMain(),
                tagName = String(main.tagName).toLowerCase();

            // 判断是否input或textarea输入框
            if (tagName !== 'input' && tagName !== 'textarea' && tagName !== 'password') {
                me.useAgent = true;
            }
            if (me.useAgent) {
                me.renderInput();
            }
            if (me.placeholder) {
                me.renderPlaceholder();
            }
            if (me.useEye) {
                me.renderEye();
            }
            // 设置_rendered
            main.setAttribute('_rendered', 'true');
        },
        initBehavior: function () {
            var me = this,
                main = me.getMain();
            // 设置readonly状态
            me.setReadonly(!!me.readonly);

            var input = me.getInput();
            var placeholder = me.getPlaceholder();
            if (input.value && placeholder) {
                placeholder.style.display = 'none';
            }
            if (me.value !== undefined) {
                me.setValue(me.value);
            }
            // 绑定事件
            main.onpaste =
                main.onkeydown = me.getPressDownHandler;
            main.onkeyup = me.getPressUpHandler;
            main.onkeypress = me.getPressHandler;
            main.onfocus = me.getFocusHandler;
            main.onblur = me.getBlurHandler;
            main.onchange = me.getChangeHandler;
        },

        /**
         * @name 获取获焦事件处理函数
         * @private
         * @return {Function}
         */
        getFocusHandler: function (e) {
            // this -> control's main element
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));

            if (me.autoHideError) {
                me.hideError();
            }
            me.onfocus(e);
        },

        /**
         * @name 获取失焦事件处理函数
         * @private
         * @return {Function}
         */
        getBlurHandler: function (e) {
            // this -> control's main element
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));

            if (me.allowSpace === false) {
                me.removeSpace();
            }

            var value = me.getValue();
            if (me.placeholder) {
                (value ? me.hidePlaceholder() : me.showPlaceholder());
            }
            if (me.useEye) {
                (value ? me.showEye() : me.hideEye());
            }

            if (me.autoValidate) {
                me.validate();
            }
            if (!value && me.hideBlankError) {
                me.hideError();
            }
            me.onblur(e);
        },
        removeSpace: function () {
            var me = this,
                value = me.getValue();
            var v = value.replace(/\s/ig, '');
            if (value !== v) {
                me.setValue(v);
            }
        },
        /**
         * @name 获取键盘敲击的事件handler
         * @private
         * @return {Function}
         */
        getPressHandler: function (e) {
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));

            e = e || hui.window.event;
            var keyCode = e.keyCode || e.which;
            if (keyCode == 13) { // enter
                return me.onenter();
            }
            me.onkeypress(e);
        },
        getPressDownHandler: function (e) {
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));
            e = e || hui.window.event;
            var keyCode = e.keyCode || e.which;
            if (keyCode != 8) { // back/delete
                me.hidePlaceholder('force');
            }
            hui.window.setTimeout(function () {
                me.onkeydown(e);
            }, 5);
        },
        getPressUpHandler: function (e) {
            var main = this,
                me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid')),
                value = me.getValue();
            (value ? me.hidePlaceholder('force') : me.showPlaceholder());
            // 注：搜狗输入法会默认加个空格占位，去掉的话会导致无法输入！
            if (value.indexOf(' ') !== value.length - 1 && me.allowSpace === false) {
                me.removeSpace();
            }

            if (me.useEye) {
                (value ? me.showEye() : me.hideEye());
            }

            me.onkeyup(e);
        },
        getChangeHandler: function (e) {
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));
            var value = (e && (e.target || e.srcElement)) ? me.getMain().value : e;
            me.onchange(value);
        },
        hidePlaceholder: function (sign) {
            var me = this,
                input = me.getInput(),
                placeholder = me.getPlaceholder();
            if (placeholder) {
                if (sign === false) {
                    placeholder.style.display = 'block';
                }
                else if (sign === 'force') {
                    placeholder.style.display = 'none';
                }
                else {
                    placeholder.style.display = input.value ? 'none' : 'block';
                }
            }
        },
        showPlaceholder: function () {
            this.hidePlaceholder(false);
        },
        hideEye: function (sign) {
            var me = this,
                input = me.getInput(),
                eye = me.getEye();
            if (eye) {
                if (sign === false) {
                    eye.style.display = 'block';
                }
                else if (sign === 'force') {
                    eye.style.display = 'none';
                }
                else {
                    eye.style.display = input.value ? 'block' : 'none';
                }
            }
        },
        showEye: function () {
            this.hideEye(false);
        },
        onkeypress: new Function(),
        onkeydown: new Function(),
        onkeyup: new Function(),
        onenter: new Function(),
        onfocus: new Function(),
        onblur: new Function(),
        onchange: new Function(),
        onmousedown: function () {
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));
            main = me.getMain();
            me.old_type = main.type;
            //main.type = 'text';
            if (!me.main_text) {
                me.main_text = document.createElement('SPAN');
                me.main_text.innerHTML = main.outerHTML.replace(/type\=\"?password\"?/i, 'type="text" '); //'"
                me.main_text.childNodes[0].style.marginLeft = '0px';
                main.parentNode.appendChild(me.main_text);
                main.parentNode.insertBefore(me.main_text, main.nextSibling);
            }
            me.main_text.childNodes[0].value = main.value;
            me.main_text.style.display = 'block';
            main.style.display = 'none';


        },
        onmouseup: function () {
            var main = this;
            var me = main.getMain ? main : hui.Control.getById(main.getAttribute('ctrid'));
            main = me.getMain();
            main.type = me.old_type || 'text';

            if (me.main_text) {
                me.main_text.style.display = 'none';
                main.style.display = 'block';
                main.parentNode.removeChild(me.main_text);
                me.main_text = null;
            }

        },

        /** 
         * @name 获焦并选中文本
         * @public
         */
        focusAndSelect: function () {
            this.getMain().select();
        },

        /**
         * @name 释放控件
         * @public
         */
        dispose: function () {
            // 卸载main的事件
            var main = this.getMain();
            main.onkeypress = null;
            main.onchange = null;
            main.onpropertychange = null;
            main.onfocus = null;
            main.onblur = null;

            hui.Control.prototype.dispose.call(this);
        }
    };

    // hui.TextInput 继承了 hui.Control
    hui.inherits(hui.TextInput, hui.Control);

});
'::hui_util::';
'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                   

hui.define('hui_util', [], function () {

    hui.util = {};

    /**
     * @name 将innerHTML生成的元素append到elem后面
     * @public
     * @param {HTMLElement} elem 父元素
     * @param {String} html 子元素HTML字符串
     */
    hui.util.appendHTML = function (elem, html) {
        if (window.jQuery) {
            return window.jQuery(elem).append(html);
        }
        else {
            var node = document.createElement('DIV');
            node.innerHTML = html;
            elem.appendChild(node);
            var list = [];
            for (var i = 0, len = node.childNodes.length; i < len; i++) {
                list[i] = node.childNodes[i];
            }
            for (var i = 0, len = list.length; i < len; i++) {
                //for (var i=list.length--; i>-1; i--) {
                elem.appendChild(list[i]);
            }
            elem.removeChild(node);

            return elem;
        }
    };
    /**
     * @name 将innerHTML生成的元素append到elem后面
     * @public
     * @param {HTMLElement} elem 父元素
     * @param {String} html 子元素HTML字符串
     */
    hui.util.getDom = function (str) {
        var list = [],
            wrap = document.createElement('DIV');
        wrap.innerHTML = str;
        for (var i = 0, len = wrap.childNodes.length; i < len; i++) {
            if (wrap.childNodes[i].nodeType == 1) {
                list.push(wrap.childNodes[i]);
            }
        }
        return list;
    };

    /**
     * @name 在当前元素直系祖父节点中查找有className的元素
     * @public
     * @param {Element} parentElement DOM元素
     * @param {String} className
     */
    hui.util.findParentByClassName = function (parentElement, className) {
        var control = null;
        while (parentElement && parentElement.tagName) {
            //label标签自带control属性!!
            if (parentElement && hui.Control.hasClass(parentElement, className)) {
                control = parentElement;
                break;
            }
            // 未找到直接父控件则将control从hui.window.childControl移动到action.childControl中
            else if (~',html,body,'.indexOf(',' + String(parentElement.tagName).toLowerCase() + ',')) {
                break;
            }
            parentElement = parentElement.parentNode;
        }
        return control;
    };
    /**
     * @name 在当前元素前后兄弟节点中查找有className的元素
     * @public
     * @param {Element} parentElement DOM元素
     * @param {String} className
     */
    hui.util.findSiblingByClassName = function (cur, className, pre) {
        var control = null,
            element = cur;
        if (!pre || pre == 'next' || pre == 'nxt' || pre == 'last') {
            while (element) {
                if (hui.Control.hasClass(element, className)) {
                    control = element;
                    if (pre !== 'last' && element !== cur) break;
                }
                element = element.nextSibling;
            }
        }
        if (!pre || pre == 'pre' || pre == 'first') {
            while (element) {
                if (hui.Control.hasClass(element, className)) {
                    control = element;
                    if (pre !== 'first' && element !== cur) break;
                }
                element = element.previousSibling;
            }
        }
        return control;
    };

    hui.util.hasClass = function (element, className) {
        if (window.jQuery) {
            return window.jQuery(element).hasClass(className);
        }
        else {
            return (' ' + element.className + ' ').indexOf(' ' + className + ' ') != -1;
        }
    };
    hui.util.addClass = function (element, className) {
        if (window.jQuery) {
            return window.jQuery(element).addClass(className);
        }
        else {
            if (~'[object Array][object NodeList]'.indexOf(Object.prototype.toString.call(element))) {
                for (var i = 0, len = element.length; i < len; i++) {
                    hui.util.addClass(element[i], className);
                }
            }
            else if (element) {
                hui.util.removeClass(element, className);
                element.className = (element.className + ' ' + className).replace(/(\s)+/ig, ' ');
            }
            return element;
        }
    };
    // Support * and ?, like hui.util.removeClass(elem, 'daneden-*');
    hui.util.removeClass = function (element, className) {
        if (window.jQuery && String(className).indexOf('*') === -1 && String(className).indexOf('?') === -1) {
            return window.jQuery(element).removeClass(className);
        }
        else {
            if (~'[object Array][object NodeList]'.indexOf(Object.prototype.toString.call(element))) {
                for (var i = 0, len = element.length; i < len; i++) {
                    hui.util.removeClass(element[i], className);
                }
            }
            else if (element) {
                var list = className.replace(/\s+/ig, ' ').split(' '),
                    /* Attention: str need two spaces!! */
                    str = (' ' + (element.className || '').replace(/(\s)/ig, '  ') + ' '),
                    name,
                    rex;
                // 用list[i]移除str
                for (var i = 0, len = list.length; i < len; i++) {
                    name = list[i];
                    name = name.replace(/(\*)/g, '\\S*').replace(/(\?)/g, '\\S?');
                    rex = new RegExp(' ' + name + ' ', 'ig');
                    str = str.replace(rex, ' ');
                }
                str = str.replace(/(\s)+/ig, ' ');
                str = str.replace(/^(\s)+/ig, '').replace(/(\s)+$/ig, '');
                element.className = str;
            }
            return element;
        }
    };

    hui.util.getDocumentHead = function (doc) {
        doc = doc || document;
        return doc.head || doc.getElementsByTagName('head')[0] || doc.documentElement;
    };
    hui.util.hasCssString = function hasCssString(id, doc) {
        var sheets,
            c,
            result = false;
        doc = doc || document;
        if (doc.createStyleSheet && (sheets = doc.styleSheets)) {
            for (var i = 0, len = sheets.length; i < len; i++) {
                c = sheets[i];
                if (c && c.owningElement && c.owningElement.id === id) {
                    result = c.owningElement;
                    break;
                }
                else if (c && c.ownerNode && c.ownerNode.id === id) {
                    result = c.ownerNode;
                    break;
                }
            }
        }
        else if ((sheets = doc.getElementsByTagName('style'))) {
            for (var i = 0, len = sheets.length; i < len; i++) {
                c = sheets[i];
                if (c.id === id) {
                    result = c;
                    break;
                }
            }
        }

        return result;
    };
    hui.util.removeCssString = function removeCssString(id, doc) {
        var parent,
            result = hui.util.hasCssString(id, doc);
        if (result) {
            parent = result.parentNode;
            parent.removeChild(result);
        }
    };

    hui.util.importCssString = function importCssString(cssText, id, doc) {
        hui.util.removeCssString(id, doc);
        doc = doc || document;

        var style = document.createElement('style');
        if (id) {
            style.id = id;
        }
        var head = doc.head || doc.body || doc.documentElement;
        head.insertBefore(style, head.lastChild);
        if (head !== doc.documentElement && style.nextSibling) {
            head.insertBefore(style.nextSibling, style);
        }
        style.setAttribute('type', 'text/css');
        // all browsers, except IE before version 9
        if (style.styleSheet) {
            style.styleSheet.cssText = cssText;
        }
        // Internet Explorer before version 9
        else {
            style.appendChild(document.createTextNode(cssText));
        }

        return style;
    };

    hui.util.insertCssRule = function (className, cssText) {
        var list = document.getElementsByTagName('style'),
            style = list && list.length ? list[list.length - 1] : hui.util.importCssString(''),
            sheet = style.sheet ? style.sheet : style.styleSheet,
            rules = sheet.cssRules || sheet.rules,
            index = rules.length,
            pre = className.indexOf('{'),
            nxt;
        if (pre !== -1) {
            nxt = className.indexOf('}', pre + 1);
            cssText = className.substring(pre + 1, nxt === -1 ? className.length : nxt);
            className = className.substring(0, pre);
        }
        cssText = String(cssText).replace(/(^\s+|\s+$)/g, '');
        if (cssText.indexOf('{') === 0) {
            cssText = cssText.substring(1, cssText.length);
        }
        if (cssText.indexOf('}') === cssText.length - 1) {
            cssText = cssText.substring(0, cssText.length - 2);
        }

        // all browsers, except IE before version 9
        if (sheet.insertRule) {
            sheet.insertRule(className + '{' + cssText + '}', index);
        }
        else {
            // Internet Explorer before version 9
            if (sheet.addRule) {
                sheet.addRule(className, cssText, index);
            }
        }
    };
    hui.util.addCssRule = hui.util.insertCssRule;


    hui.util.importCssStylsheet = function importCssStylsheet(uri, doc) {
        doc = doc || document;
        if (doc.createStyleSheet) {
            doc.createStyleSheet(uri);
        }
        else {
            var link = hui.util.createElement('link');
            link.rel = 'stylesheet';
            link.href = uri;

            hui.util.getDocumentHead(doc).appendChild(link);
        }
    };

    /** 
     * @name 对目标字符串进行格式化
     * @public
     * @param {String} source 目标字符串
     * @param {Object|String...} opts 提供相应数据的对象或多个字符串
     * @return {String} 格式化后的字符串
     */
    hui.util.format = function (source, opts) {
        function handler(match, key) {
            var type = String(key).indexOf('!!') === 0 ? 'decode' : String(key).indexOf('!') === 0 ? '' : 'encode',
                parts = key.replace(/^!!?/, '').split('.'),
                part = parts.shift(),
                cur = data,
                variable;
            while (part) {
                if (cur[part] !== undefined) {
                    cur = cur[part];
                }
                else {
                    cur = undefined;
                    break;
                }
                part = parts.shift();
            }

            variable = cur;
            if ('[object Function]' === toString.call(variable)) {
                variable = variable(key);
            }
            if (undefined !== variable) {
                variable = String(variable);
                // encodeURIComponent not encode '
                var fr = '&|<|>| |\'|"|\\'.split('|'),
                    to = '&amp;|&lt;|&gt;|&nbsp;|&apos;|&quot;|&#92;'.split('|');
                if (type === 'decode') {
                    for (var i = fr.length - 1; i > -1; i--) {
                        variable = variable.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
                    }
                }
                else if (type === 'encode') {
                    for (var i = 0, l = fr.length; i < l; i++) {
                        variable = variable.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
                    }
                }
            }

            return (undefined === variable ? '' : variable);
        }

        source = String(source);
        var data = Array.prototype.slice.call(arguments, 1),
            toString = Object.prototype.toString;
        if (data.length) {
            data = (data.length == 1 ?
                /* ie 下 Object.prototype.toString.call(null) == '[object Object]' */
                (opts !== null && (/\[object (Array|Object)\]/.test(toString.call(opts))) ? opts : data) : data);

            return source.replace(/#\{(.+?)\}/g, handler).replace(/\{\{(.+?)\}\}/g, handler);
        }
        return source;
    };

    /** 
     * @name 对数组进行排序
     * @public
     * @param {Array} list 目标数组
     * @param {String} field 目标排序字段
     * @param {String} order 升序（默认）或降序
     * @return {array} 排序后的数组
     */
    hui.util.sortBy = function (list, field, order) {
        if (list && list.sort && list.length) {
            list.sort(function (a, b) {
                var m, n;
                m = String(a[field]).toLowerCase();
                n = String(b[field]).toLowerCase();

                if (String(parseInt('0' + m, 10)) == m && String(parseInt('0' + n, 10)) == n) {
                    m = parseInt(m, 10);
                    n = parseInt(n, 10);
                }
                else {
                    if (m > n) {
                        m = 1;
                        n = -m;
                    }
                    else if (m < n) {
                        m = -1;
                        n = -m;
                    }
                    else {
                        m = 1;
                        n = m;
                    }
                }
                return (order == 'desc' ? n - m : m - n);
            });
        }
        return list;
    };

    /** 
     * @name 事件绑定与解绑
     */
    hui.util.on = function (elem, eventName, handler) {
        if (window.jQuery && window.jQuery.prototype.on) {
            return window.jQuery(elem).on(eventName, handler);
        }
        else {
            if (elem.addEventListener) {
                elem.addEventListener(eventName, handler, false);
            }
            else if (elem.attachEvent) {
                elem.attachEvent('on' + eventName, handler);
                // elem.attachEvent('on' + eventName, function(){handler.call(elem)}); 
                //此处使用回调函数call()，让 this指向elem //注释掉原因：无法解绑
            }
        }
    };
    hui.util.off = function (elem, eventName, handler) {
        if (window.jQuery && window.jQuery.prototype.off) {
            return window.jQuery(elem).off(eventName, handler);
        }
        else {
            if (elem.removeEventListener) {
                elem.removeEventListener(eventName, handler, false);
            }
            if (elem.detachEvent) {
                elem.detachEvent('on' + eventName, handler);
            }
        }
    };

    /** 
     * @name 给elem绑定onenter事件
     * @public
     * @param {HTMLElement} elem 目标元素
     * @param {Function} fn 事件处理函数
     */
    hui.util.onenter = function (elem, fn) {
        hui.util.on(elem, 'keyup', function (e) {
            e = e || hui.window.event;
            var keyCode = e.keyCode || e.which;
            if (keyCode == 13) {
                elem.onenter && elem.onenter();
                fn(elem);
            }
        });
    };

    /** 
     * @name 给elem绑定onesc事件
     * @public
     * @param {HTMLElement} elem 目标元素
     * @param {Function} fn 事件处理函数
     */
    hui.util.onesc = function (elem, fn) {
        hui.util.on(elem, 'keyup', function (e) {
            e = e || hui.window.event;
            var keyCode = e.keyCode || e.which;
            if (keyCode == 27) {
                elem.onesc && elem.onesc();
                fn(elem);
            }
        });
    };


    hui.util.getCookie = function (name) {
        var start = document.cookie.indexOf(name + '=');
        var len = start + name.length + 1;
        if ((!start) && (name != document.cookie.substring(0, name.length))) {
            return undefined;
        }
        if (start == -1) return undefined;
        var end = document.cookie.indexOf(';', len);
        if (end == -1) end = document.cookie.length;
        return unescape(document.cookie.substring(len, end));
    };
    hui.util.setCookie = function (name, value, expires, path, domain, secure) {
        expires = expires || 24 * 60 * 60 * 1000;
        var expires_date = new Date((new Date()).getTime() + (expires));
        document.cookie = name + '=' + escape(value) + ((expires) ? ';expires=' + expires_date.toGMTString() : '') + /*expires.toGMTString()*/
            ((path) ? ';path=' + path : '') + ((domain) ? ';domain=' + domain : '') + ((secure) ? ';secure' : '');
    };
    hui.util.removeCookie = function (name, path, domain) {
        if (hui.util.getCookie(name)) document.cookie = name + '=' + ((path) ? ';path=' + path : '') + ((domain) ? ';domain=' + domain : '') + ';expires=Thu, 01-Jan-1970 00:00:01 GMT';
    };

    hui.util.formatDate = function (date, fmt) {
        if (!date) date = new Date();
        fmt = fmt || 'yyyy-MM-dd HH:mm';
        var o = {
            'M+': date.getMonth() + 1, //月份      
            'd+': date.getDate(), //日      
            'h+': date.getHours() % 12 === 0 ? 12 : date.getHours() % 12, //小时      
            'H+': date.getHours(), //小时      
            'm+': date.getMinutes(), //分      
            's+': date.getSeconds(), //秒      
            'q+': Math.floor((date.getMonth() + 3) / 3), //季度      
            'S': date.getMilliseconds() //毫秒      
        };
        var week = {
            '0': '/u65e5',
            '1': '/u4e00',
            '2': '/u4e8c',
            '3': '/u4e09',
            '4': '/u56db',
            '5': '/u4e94',
            '6': '/u516d'
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? '/u661f/u671f' : '/u5468') : '') + week[date.getDay() + '']);
        }
        for (var k in o) {
            if (o.hasOwnProperty(k) && new RegExp('(' + k + ')').test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
            }
        }
        return fmt;
    };
    /*  
  将String类型解析为Date类型.  
  parseDate('2006-1-1') return new Date(2006,0,1)  
  parseDate(' 2006-1-1 ') return new Date(2006,0,1)  
  parseDate('2006-1-1 15:14:16') return new Date(2006,0,1,15,14,16)  
  parseDate(' 2006-1-1 15:14:16 ') return new Date(2006,0,1,15,14,16);  
  parseDate('不正确的格式') retrun null  
*/
    hui.util.parseDate = function (str) {
        str = String(str).replace(/^[\s\xa0]+|[\s\xa0]+$/ig, '');
        var results = null;

        //秒数 #9744242680 
        results = str.match(/^ *(\d{10}) *$/);
        if (results && results.length > 0)
            return new Date(parseInt(str) * 1000);

        //毫秒数 #9744242682765 
        results = str.match(/^ *(\d{13}) *$/);
        if (results && results.length > 0)
            return new Date(parseInt(str));

        //20110608 
        results = str.match(/^ *(\d{4})(\d{2})(\d{2}) *$/);
        if (results && results.length > 3)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]));

        //20110608 1010 
        results = str.match(/^ *(\d{4})(\d{2})(\d{2}) +(\d{2})(\d{2}) *$/);
        if (results && results.length > 5)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]));

        //2011-06-08 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) *$/);
        if (results && results.length > 3)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]));

        //2011-06-08 10:10 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) +(\d{1,2}):(\d{1,2}) *$/);
        if (results && results.length > 5)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]));

        //2011/06\\08 10:10:10 
        results = str.match(/^ *(\d{4})[\._\-\/\\](\d{1,2})[\._\-\/\\](\d{1,2}) +(\d{1,2}):(\d{1,2}):(\d{1,2}) *$/);
        if (results && results.length > 6)
            return new Date(parseInt(results[1]), parseInt(results[2]) - 1, parseInt(results[3]), parseInt(results[4]), parseInt(results[5]), parseInt(results[6]));

        return (new Date(str));
    };

    /**
     * 对特殊字符和换行符编码// .replace(/%/ig,"%-")
     */
    hui.util.encode = function (str, decode) {
        str = String(str);
        // encodeURIComponent not encode '
        var fr = '%| |&|;|=|+|<|>|,|"|\'|#|/|\\|\n|\r|\t'.split('|'),
            to = '%25|%20|%26|%3B|%3D|%2B|%3C|%3E|%2C|%22|%27|%23|%2F|%5C|%0A|%0D|%09'.split('|');
        if (decode == 'decode') {
            for (var i = fr.length - 1; i > -1; i--) {
                str = str.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
            }
        }
        else {
            for (var i = 0, l = fr.length; i < l; i++) {
                str = str.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
            }
        }
        return str;
    };
    hui.util.decode = function (str) {
        return this.encode(str, 'decode');
    };
    hui.util.encodehtml = function (str, decode) {
        str = String(str);
        // encodeURIComponent not encode '
        var fr = '&|<|>| |\'|"|\\'.split('|'),
            to = '&amp;|&lt;|&gt;|&nbsp;|&apos;|&quot;|&#92;'.split('|');
        if (decode == 'decode') {
            for (var i = fr.length - 1; i > -1; i--) {
                str = str.replace(new RegExp('\\' + to[i], 'ig'), fr[i]);
            }
        }
        else {
            for (var i = 0, l = fr.length; i < l; i++) {
                str = str.replace(new RegExp('\\' + fr[i], 'ig'), to[i]);
            }
        }
        return str;
    };
    hui.util.decodehtml = function (str) {
        return this.encodehtml(str, 'decode');
    };

    //setInnerHTML: function (elem, html){}
    hui.util.setInnerHTML = function (elem, html) {
        elem = elem && elem.getMain ? elem.getMain() : elem;
        if (elem && elem.innerHTML !== undefined) {
            elem.innerHTML = html;
        }
        return elem;
    };
    hui.util.setInnerText = function (elem, text) {
        if (!elem) return;
        if (elem.textContent !== undefined) {
            elem.textContent = text;
        }
        else {
            elem.innerText = text;
        }
    };

    hui.appendHTML = hui.util.appendHTML;
    hui.hasClass = hui.util.hasClass;
    hui.addClass = hui.util.addClass;
    hui.removeClass = hui.util.removeClass;
    // hui.format = hui.util.format;
    hui.sortBy = hui.util.sortBy;
    hui.on = hui.util.on;
    hui.off = hui.util.off;
    hui.onenter = hui.util.onenter;

    hui.getCookie = hui.util.getCookie;
    hui.setCookie = hui.util.setCookie;
    hui.removeCookie = hui.util.removeCookie;
    hui.formatDate = hui.util.formatDate;
    hui.parseDate = hui.util.parseDate;
    hui.setInnerHTML = hui.util.setInnerHTML;
    hui.setInnerText = hui.util.setInnerText;

    hui.util.importCssString('html {}');

});


'::test1::';
console.log('hui_button009');
'::test2::';
console.log('hui005');