'use strict';


var fs = require('fs');
//var path = require('path');
var crypto = require('crypto');
var through2 = require('through2');


var gulp = require('gulp');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var rename = require('gulp-rename');

// 将JS转换为能自动缓存到Localstorage的格式
function modify() {
    return through2.obj(function (file, encoding, done) {
        // ;'::hui_button==678654bgfd::';
        var str = String(file.contents);
        var list = str.split(';');
        console.log(str.substr(0, 40));

        // No modname
        var modversion = /^['"]::[^:]*::['"]/.test(list[0]) ? list.shift() : '"::::"';
        var path = file.history[0].replace(/\\\\/g, '\\');
        var mod = path.replace(file.cwd, '');
        if (/^['"]::::/.test(modversion)) {
            modversion = modversion.replace('::::', '::' + mod + '::');
        }

        var content = list.join(';');
        var md5 = crypto.createHash('md5');
        md5.update(content, 'utf8');
        var version = md5.digest('hex');

        // version
        modversion = modversion.replace(/^(['"]::[^:=]*)(::['"])/, '$1==' + version + '$2');//'"

        var txt = modversion + ';' + content;
        var outjs = '(function(){var str="' + encodeURI(txt) + '";hui.savejs?hui.savejs(str):eval(decodeURI(str));})();';
        file.contents = new Buffer(outjs);

        this.push(file);
        done();
    });
}

// 根据除hui.js的所有模块内容生产md版本列表
function finish() {
    fs.readFile(config.build + '/' + config.allfile, 'utf8', function (err, txt) {

        var vlist = JSON.stringify(txt.match(/%22::[^:]*::%22;/g)).replace(/(%22::|::%22;)/g, '').replace(/==/g, ':');

        var md5 = crypto.createHash('md5');
        md5.update(vlist, 'utf8');
        var version = md5.digest('hex');

        var outjs = 'hui.versionlist=' + vlist + ';hui.checkPackageUpdate&&hui.checkPackageUpdate("' + version + '")';

        fs.writeFile(config.versionlist, outjs, 'utf8', function (er) {
            if (er) throw er;

            fs.readFile(config.main_src, 'utf8', function (err, data) {
                var vnum_dist = data.replace(/___dist=[a-zA-Z0-9]*___/, '___dist=' + version + '___');
                fs.writeFile(config.main_src, vnum_dist, 'utf8', function (er) {
                    if (er) throw er;
                    console.log('ok dist=' + version);
                });


            });
        });

    });
}

var config = {};
config.allfile = 'all.js';
config.build = 'build';
config.versionlist = config.build + '/versionlist.js';
config.main_src = 'index2.html';

gulp.task('build', function () {
    gulp.src(['src/hui.js', 'src/*.js'])
        .pipe(concat('all.debug.js'))
        .pipe(gulp.dest(config.build));

    gulp.src(['src/hui.js'])
        .pipe(uglify())
        .pipe(modify())
        .pipe(gulp.dest(config.build))
        .on('end', function(){
            fs.readFile(config.build + '/hui.js', 'utf8', function (err, txt) {
                var version = txt.match(/%22::[^:]*::%22;/g)[0].replace(/(%22::|::%22;)/g, '').split('==')[1];

                fs.readFile(config.main_src, 'utf8', function (err, data) {
                    var vnum_dist = data.replace(/___load=[a-zA-Z0-9]*___/, '___load=' + version + '___');
                    fs.writeFile(config.main_src, vnum_dist, 'utf8', function (er) {
                        if (er) throw er;
                        
                        console.log('ok load=' + version);

                        gulp.src(['src/*.js', '!src/hui.js'])
                            .pipe(uglify())
                            .pipe(modify())
                            .pipe(gulp.dest(config.build))
                            .pipe(concat(config.allfile))
                            .pipe(gulp.dest(config.build))
                            .on('end', finish);


                    });
                });
            });
        });

});

gulp.task('minifyjs', function () {
    return gulp.src(['src/*.js'])
        .pipe(uglify()) //压缩
        //.pipe(concat('main.js'))    //合并所有js到main.js
        //.pipe(gulp.dest('hui/js'))    //输出main.js到文件夹
        .pipe(rename({
            suffix: '.min'
        })) //rename压缩后的文件名
        .pipe(gulp.dest('hui')); //输出
});