'use strict';
//   __    __           ______   ______  _____    __  __     
//  /\ \  /\ \ /'\_/`\ /\  _  \ /\__  _\/\  __`\ /\ \/\ \    
//  \ `\`\\/'//\      \\ \ \/\ \\/_/\ \/\ \ \/\ \\ \ \ \ \   
//   `\ `\ /' \ \ \__\ \\ \  __ \  \ \ \ \ \ \ \ \\ \ \ \ \  
//     `\ \ \  \ \ \_/\ \\ \ \/\ \  \ \ \ \ \ \_\ \\ \ \_\ \ 
//       \ \_\  \ \_\\ \_\\ \_\ \_\  \ \_\ \ \_____\\ \_____\
//        \/_/   \/_/ \/_/ \/_/\/_/   \/_/  \/_____/ \/_____/
//                                                                                                                                      
//     

/**
 * @name HUI是一个富客户端应用的前端MVC框架
 * @public
 * @author haiyang5210
 * @date 2015-06-25 10:48
 */

// 使用window.hui定义可能会导致速度下降约7倍
window.hui = window.hui ? window.hui : {};

/**
 * @name Localstorage缓存方案
 */
hui.loadjs = function (url) {
    var scr = document.createElement('script');
    scr.src = url;
    document.documentElement.appendChild(scr);
};
hui.savejs = function (str) {
    var item = str.match(/^%22::[^:]*::%22;/)[0].replace(/(%22::|::%22;)/g, '').split('==');
    var mod = item[0];
    var ver = item[1];
    var dist_str = window.decodeURI(str); // .replace(/%0A/g, '\n').replace(/%22/g, '"').replace(/%25/g, '%');
    window.localStorage && window.localStorage.setItem(mod, dist_str);

    var dist_vlist = window.localStorage ? (window.localStorage.getItem('dist_vlist') || '') : '';
    dist_vlist = dist_vlist.replace(',' + mod + ':', ',:').replace(/,::[^,]*/, '');
    dist_vlist = dist_vlist + ',' + mod + ':' + ver;
    window.localStorage && window.localStorage.setItem('dist_vlist', dist_vlist);

    eval(dist_str);
};
hui.checkPackageUpdate = function (dist_vnum) {
    var mod;
    var version;
    var local;
    var item;
    var list = hui.versionlist;
    for (var i in list) {
        item = list[i];
        mod = item.split(':')[0];
        version = item.split(':')[1];
        local = window.localStorage ? String(window.localStorage.getItem(mod) || '') : '';
        if (local.indexOf('::' + item.replace(':', '==') + '::') !== 1) {
            hui.needreloadalljs = true;
        }
    }
    // 不需要重新加载
    if (!hui.needreloadalljs) {
        for (var i in list) {
            item = list[i];
            mod = item.split(':')[0];
            eval(window.localStorage.getItem(mod));
        }
    }
    // 有更新，需要重新加载
    else {
        hui.loadjs(hui.allsrc);
        hui.needreloadalljs = false;
    }

    // 缓存最新版本列表
    window.localStorage && window.localStorage.setItem('dist_vlist', (list.length ? ',' : '') + list.join(','));
    window.localStorage && window.localStorage.setItem('dist_vnum', '___' + dist_vnum + '___');
};
hui.loadFromLocalStorage = function () {
    var list = (window.localStorage ? window.localStorage.getItem('dist_vlist') || '' : '').split(',');
    for (var i in list) {
        list[i] && eval(window.localStorage.getItem(list[i].split(':')[0]));
    }
};
hui.updateByVersionList = function () {
    hui.loadjs('build/versionlist.js');
};

// hui.allsrc = 'build/all.js';
// hui.dist_vnum = '___4e0a6ef4b64590a468515cd0f698a19c___';
// hui.alldebug = 'build/all.debug.js';

// if (window.location.href.indexOf('debug') !== -1) {
//     hui.loadjs(hui.alldebug);
// }
// // 版本有更新，加载最新版本列表
// else if (!window.localStorage || window.localStorage.getItem('dist_vnum') !== hui.dist_vnum) {
//     window.localStorage.setItem('dist_vnum', hui.dist_vnum);
//     hui.loadjs(hui.allsrc);
// }
// // 版本无更新，直接从Localstorage里读取
// else {
//     hui.loadFromLocalStorage();
// }



if (!hui.define) {
    // Nodejs support 'require' and does not support 'define', browser does not supported both. 
    // hui.require(['jquery', 'button'], function(){})
    hui.require = function (n, cb, asyc) {
        if (!n) return;
        if (Object.prototype.toString.call(n) !== '[object Array]') {
            n = [n];
        }
        hui.define('', n, cb, asyc);
    };
    //define('lib_module',['lib@0.0.1','json@0.0.1'], function(exports){exports.todo='...';});
    hui.define = function (name, deps, fun, force, asyc) {
        if (force) hui.define.removeModule(name);
        if (!name || !hui.define.getModule(name)) {
            //Name missing. Allow for anonymous modules
            name = typeof name !== 'string' ? '' : String(name).toLowerCase();
            deps = deps && deps.splice && deps.length ? deps : [];
            var left = [];
            for (var i = 0, len = deps.length; i < len; i++) {
                left.push(String(deps[i]).toLowerCase());
            }

            var conf = {
                name: name,
                depend: deps,
                left: left,
                todo: fun,
                loaded: false,
                exports: {},
                asyc: asyc
            };
            hui.define.modules.push(conf);

            hui.define.checkDepend();

            if (asyc === 'syc' || hui.define.autoload !== false) {
                conf.left.length && hui.define.loadmod(conf.left);
            }
        }
    };
    // 注：模块源地址
    hui.define.source = 'http://bpmjs.org/api/combo??';
    // 注：已通过<script>标签发送请求的模块
    hui.define.loadfile = [];
    // 注：请求成功返回但尚未初始化的模块
    hui.define.modules = [];
    // 注：执行初始化后的模块
    hui.define.parsed = [];
    // 注：是否自动加载依赖模块
    hui.define.autoload = false;

    hui.define.loadmod = function (n, conf) {
        var left = [];
        for (var i = 0; i < n.length; i++) {
            if (!hui.define.checkLoaded(n[i], conf)) {
                left.push(n[i]);
            }
        }
        if (left.length) {
            hui.define.loadfile = hui.define.loadfile.concat(left);

            var url = hui.define.source + left.join(',');

            var ex = [];
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                hui.define.modules[i].name && ex.push(hui.define.modules[i].name);
            }
            var param = ex.length ? '?n=' + ex.join(',') : '';
            param = (param || '') + (hui.require.debug ? (param ? '&debug=true' : '?debug=true') : '');

            var script = document.createElement('script');
            script.src = url + (url.indexOf('.') === 0 ? '' : param);
            document.getElementsByTagName('head')[0].appendChild(script);
        }
    };
    hui.define.checkLoaded = function (n, conf) {
        var loaded = !!hui.define.getModule(n, conf);
        if (!loaded) {
            for (var i = 0, len = hui.define.loadfile.length; i < len; i++) {
                if (hui.define.loadfile[i].split('@')[0].replace('./', '') === n) {
                    loaded = true;
                    break;
                }
            }
        }
        return loaded;
    };

    hui.define.checkDepend = function () {
        hui.define.modules = hui.define.modules || [];
        // 注: 只能用倒序, 否则会碰到依赖项未定义的错误
        for (var i = hui.define.modules.length - 1; i > -1; i--) {
            var m = hui.define.modules[i];

            for (var j = 0, len2 = hui.define.parsed.length; j < len2; j++) {
                var n = hui.define.parsed[j];
                for (var k = m.left.length - 1; k > -1; k--) {
                    if (m.left[k].replace('./', '').split('@')[0] == n) {
                        m.left.splice(k, 1);
                    }
                }
            }

            if (!m.loaded && m.left.length < 1) {
                m.loaded = true;
                // 放在前面未执行todo就放到loaded中了，会误触其他函数的todo，只能放在后面
                // [注: push放在这里则后面检测依赖只能用倒序，放在后面不好实现][有误]
                m.todo && m.todo(m.exports);
                // 放在todo前面有问题，依赖项刚加载还没来得及执行就触发了其他依赖此项的todo，会报依赖项未定义的错误
                m.name && hui.define.parsed.push(m.name);

                i = hui.define.modules.length;
            }
        }
    };

    hui.define.getModule = function (n) {
        n = n.split('@')[0].replace('./', '');
        var module = null;
        if (hui.define.modules) {
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                if (hui.define.modules[i] && hui.define.modules[i].name === n) {
                    module = hui.define.modules[i];
                    break;
                }
            }
        }
        return module;
    };
    hui.define.removeModule = function (n) {
        n = n.split('@')[0].replace('./', '');
        var result = false;
        if (hui.define.modules) {
            for (var i = 0, len = hui.define.modules.length; i < len; i++) {
                if (hui.define.modules[i] && hui.define.modules[i].name === n) {
                    hui.define.modules.splice(i, 1);
                    result = true;
                    break;
                }
            }
        }
        return result;
    };

    hui.define.checkLeft = function () {
        var left = [];
        var list = hui.define.modules;
        for (var i = 0, len = list.length; i < len; i++) {
            left = left.concat(hui.define.modules[i].left);
        }
        return left;
    };
    hui.define.loadLeft = function () {
        var left = hui.define.checkLeft();
        left && hui.define.loadmod(left);
    };
}

hui.define('hui', [], function () {
    // !!! global.hui = ...
    hui.window = window; /*hui.bocument = document;//注：hui.bocument与document不相同!!*/
    hui.window.cc = [];

    /** 
     * @name 为对象绑定方法和作用域
     * @param {Function|String} handler 要绑定的函数，或者一个在作用域下可用的函数名
     * @param {Object} obj 执行运行时this，如果不传入则运行时this为函数本身
     * @param {args* 0..n} args 函数执行时附加到执行时函数前面的参数
     * @returns {Function} 封装后的函数
     */
    hui.fn = function (func, scope) {
        if (Object.prototype.toString.call(func) === '[object String]') {
            func = scope[func];
        }
        if (Object.prototype.toString.call(func) !== '[object Function]') {
            throw 'Error "hui.util.fn()": "func" is null';
        }
        var xargs = arguments.length > 2 ? [].slice.call(arguments, 2) : null;
        return function () {
            var fn = '[object String]' == Object.prototype.toString.call(func) ? scope[func] : func,
                args = (xargs) ? xargs.concat([].slice.call(arguments, 0)) : arguments;
            return fn.apply(scope || fn, args);
        };
    };

    /**
 * @name 原型继承
 * @public
 * @param {Class} child 子类
 * @param {Class} parent 父类
 * @example 
    hui.ChildControl = function (options, pending) {
        //如果使用this.constructor.superClass.call将无法继续继承此子类,否则会造成死循环!!
        hui.ChildControl.superClass.call(this, options, 'pending');
        //进入控件处理主流程!
        if (pending != 'pending') {
            this.enterControl();
        }
    };
    hui.Form.prototype = {
        render: function () {
            hui.Form.superClass.prototype.render.call(this);
            //Todo...
        }
    };
    hui.inherits(hui.Form, hui.Control);
 */
    hui.inherits = function (child, parent) {
        var clazz = new Function();
        clazz.prototype = parent.prototype;

        var childProperty = child.prototype;
        child.prototype = new clazz();

        for (var key in childProperty) {
            if (childProperty.hasOwnProperty(key)) {
                child.prototype[key] = childProperty[key];
            }
        }

        child.prototype.constructor = child;

        //child是一个function
        //使用super在IE下会报错!!!
        child.superClass = parent;
    };



});
